/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.designer.formdesigner.XOUserObject;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class AttributesCheckTreeNode
extends CheckTreeNode {
    protected boolean allowGroupInGroup = false;
    protected List<TypeDescription> recursiveTypeDescriptions = new ArrayList<TypeDescription>();
    private boolean belongsToGroup = false;
    private static Comparator<TreeNode> ATTRIBUTE_COMPARATOR;

    protected AttributesCheckTreeNode(XOUserObject obj) {
        super((Object)obj);
        XOUserObject xou = this.getUserObject();
        if (xou.type == 3 || xou.type == 0) {
            // empty if block
        }
    }

    public XOUserObject getUserObject() {
        return (XOUserObject)super.getUserObject();
    }

    protected void onLoading() {
        XOUserObject xou = this.getUserObject();
        this.belongsToGroup = this.getParent() == null ? xou.type == 2 : ((AttributesCheckTreeNode)this.getParent()).belongsToGroup;
        ObjectTypeDescription otd = null;
        TypeDescription objectMember = xou.member;
        if (xou.type == 1) {
            otd = (ObjectTypeDescription)objectMember.asMethod().getResultType();
        } else if (xou.type == 2) {
            this.belongsToGroup = true;
            otd = (ObjectTypeDescription)objectMember.asMethod().getResultType().getElementType();
        } else if (xou.member instanceof ObjectTypeDescription) {
            otd = (ObjectTypeDescription)objectMember;
        }
        if (otd != null) {
            this.loadAllAttributes(otd, xou);
        }
    }

    protected boolean rejectMember(MethodTypeDescription member) {
        return member.isSynthesized() || member.isHidden() || member.isStatic() || this.belongsToGroup && member.getResultType().isBinary() || !XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)member.asAttribute()) && !member.hasGetter();
    }

    protected AttributesCheckTreeNode createCheckTreeNode(XOUserObject userObj) {
        AttributesCheckTreeNode treeNode = new AttributesCheckTreeNode(userObj);
        ArrayList<TypeDescription> recursiveDescriptions = new ArrayList<TypeDescription>(this.recursiveTypeDescriptions);
        treeNode.setRecursiveTypeDescriptions(recursiveDescriptions);
        return treeNode;
    }

    private static Comparator<TreeNode> getAttributeComparator() {
        if (ATTRIBUTE_COMPARATOR == null) {
            ATTRIBUTE_COMPARATOR = new Comparator<TreeNode>(){

                @Override
                public int compare(TreeNode treeNode1, TreeNode treeNode2) {
                    String name1 = this.getString((AttributesCheckTreeNode)treeNode1);
                    String name2 = this.getString((AttributesCheckTreeNode)treeNode2);
                    return name1.compareTo(name2);
                }

                private String getString(AttributesCheckTreeNode attributesCheckTreeNode) {
                    String result = "";
                    if (attributesCheckTreeNode != null && attributesCheckTreeNode.getUserObject() != null) {
                        XOUserObject userObject = attributesCheckTreeNode.getUserObject();
                        Object value = userObject.getValue();
                        result = value.toString();
                    }
                    return result;
                }
            };
        }
        return ATTRIBUTE_COMPARATOR;
    }

    private AttributesCheckTreeNode createCheckTreeNode(XOUserObject userObj, boolean addTypeDescriptionToRecursion) {
        AttributesCheckTreeNode treeNode = this.createCheckTreeNode(userObj);
        if (addTypeDescriptionToRecursion) {
            TypeDescription description = ((MethodTypeDescription)userObj.member).getResultType();
            treeNode.recursiveTypeDescriptions.add(description);
        }
        return treeNode;
    }

    private void loadAllAttributes(ObjectTypeDescription otd, XOUserObject xou) {
        this.loadObjectMembers(otd, xou);
        for (SuperType superType : otd.getSuperTypes()) {
            ObjectTypeDescription superotd;
            if (superType.isHidden() || (superotd = superType.getObjectType()).isInterface()) continue;
            this.loadAllAttributes(superotd, xou);
        }
    }

    private void loadObjectMembers(ObjectTypeDescription otd, XOUserObject xou) {
        MethodTypeDescription[] members = otd.getMembers(18, 0L, 0x2000000L);
        ObjectTypeDescription.AttributeByPosition orderComparator = ObjectTypeDescription.ATTRIBUTE_BY_POSITION_COMPARATOR;
        Arrays.sort(members, orderComparator);
        for (MethodTypeDescription member : members) {
            if (this.rejectMember(member)) continue;
            XOUserObject xoUserObject = null;
            boolean addTypeDescriptionToRecursion = false;
            if (otd instanceof XObjectTypeDescription && XObjectTypeDescription.isGroupAttribute(member.asAttribute())) {
                if (!this.belongsToGroup || this.allowGroupInGroup) {
                    xoUserObject = xou.createChild(member, 2);
                }
            } else {
                TypeDescription memberResult = member.getResultType();
                if (memberResult.isPredefined() || memberResult.isEnum()) {
                    xoUserObject = xou.createChild(member, 3);
                } else if ((memberResult.isObject() || memberResult.isInvokeable()) && !this.recursiveTypeDescriptions.contains(memberResult)) {
                    addTypeDescriptionToRecursion = true;
                    xoUserObject = xou.createChild(member, 1);
                }
            }
            if (xoUserObject == null) continue;
            this.doInsert((TreeNode)this.createCheckTreeNode(xoUserObject, addTypeDescriptionToRecursion));
        }
    }

    private boolean doInsert(TreeNode treeNode) {
        Comparator<TreeNode> comparator = AttributesCheckTreeNode.getAttributeComparator();
        int indexToInsert = 0;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            TreeNode node = (TreeNode)i$.next();
            int compare = comparator.compare(treeNode, node);
            if (compare == 0) {
                return false;
            }
            if (compare < 0) break;
            ++indexToInsert;
        }
        if (indexToInsert < this.getChildCount()) {
            this.insert(treeNode, indexToInsert);
        } else {
            this.add(treeNode);
        }
        return true;
    }

    private void setRecursiveTypeDescriptions(List<TypeDescription> recursiveTypeDescriptions) {
        this.recursiveTypeDescriptions = recursiveTypeDescriptions;
    }
}

