/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bpm.designer.formdesigner.AttributesCheckTree;
import oracle.bpm.designer.formdesigner.XOUserObject;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.TreeModelAdapter;
import oracle.bpm.ui.event.TreeModelEvent;
import oracle.bpm.ui.event.TreeModelListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.tree.CheckTreeNode;
import oracle.bpm.ui.tree.TreeNode;

public class AttributeSelectionPanel
extends Panel {
    private LinkedHashMap attributes;
    private MyListModel attributesModel;
    private String[] atts;
    private Hashtable groupedAtts;
    private String[] groups;
    private Hashtable innerXos;
    private List<BaseAction> otherActions;
    private CheckTreeNode root = null;
    private boolean wasCancelled = false;
    private XObjectTypeDescription xotd = null;

    AttributeSelectionPanel(UiContainer parent, XObjectTypeDescription xotd) {
        super(parent);
        this.xotd = xotd;
        this.build();
    }

    AttributeSelectionPanel(UiContainer parent, XObjectTypeDescription xotd, final Dialog parentDialog) {
        this(parent, xotd);
        if (parentDialog != null) {
            this.otherActions = new ArrayList<BaseAction>();
            BaseAction cancelAction = new BaseAction(LibMsg.CANCEL){

                public void run() {
                    AttributeSelectionPanel.this.wasCancelled = true;
                    parentDialog.dispose();
                }
            };
            BaseAction closeAction = new BaseAction(CoreMsg.OK){

                public void run() {
                    AttributeSelectionPanel.this.createDatas();
                    parentDialog.dispose();
                }
            };
            this.otherActions.add(cancelAction);
            this.otherActions.add(closeAction);
        }
    }

    public String[] getAttributes() {
        return this.atts;
    }

    public LinkedHashMap getAttributesMap() {
        return this.attributes;
    }

    public Hashtable getGroupedAttributesHash() {
        return this.groupedAtts;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public Hashtable getInnerXOHash() {
        return this.innerXos;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    protected void createDatas() {
        this.groupedAtts = new Hashtable();
        String[][] values = new String[2][2];
        this.innerXos = new Hashtable();
        this.createDatas(this.root, "", this.groupedAtts, values, this.innerXos);
        this.atts = values[0];
        this.groups = values[1];
        this.attributes = new LinkedHashMap();
        this.createMap(this.attributes, this.attributesModel.toArray(), 0, "");
    }

    private List<BaseAction> getOrderActions(final oracle.bpm.ui.List attributeList) {
        ArrayList<BaseAction> result = new ArrayList<BaseAction>();
        class MoveAction
        extends BaseAction {
            private final boolean up;

            public MoveAction(boolean up) {
                super(up ? DesignerMsg.UP : DesignerMsg.DOWN);
                this.up = up;
            }

            public void run() {
                int sourceIndex = attributeList.getSelectedIndex();
                if (this.isValid(sourceIndex)) {
                    XOUserObject temp2;
                    XOUserObject temp = (XOUserObject)AttributeSelectionPanel.this.attributesModel.getElementAt(sourceIndex);
                    int targetIndex = sourceIndex;
                    while (!(temp2 = (XOUserObject)AttributeSelectionPanel.this.attributesModel.getElementAt(targetIndex -= this.getIncrement())).getPrefix().equals(temp.getPrefix()) && this.isValid(targetIndex)) {
                    }
                    if (this.isValidOrBorder(targetIndex) && temp2.getPrefix().equals(temp.getPrefix())) {
                        if (!this.shouldExchange(sourceIndex, targetIndex)) {
                            AttributeSelectionPanel.this.attributesModel.removeElement(sourceIndex);
                            int nextIndex = targetIndex + this.getIncrement();
                            AttributeSelectionPanel.this.attributesModel.insertElementAt(temp, nextIndex);
                            attributeList.setSelectedIndex(nextIndex);
                        } else {
                            AttributeSelectionPanel.this.attributesModel.setElementAt(temp2, sourceIndex);
                            AttributeSelectionPanel.this.attributesModel.setElementAt(temp, targetIndex);
                            attributeList.setSelectedIndex(targetIndex);
                        }
                    } else if (targetIndex == this.getBorder() && "".equals(temp.getPrefix())) {
                        AttributeSelectionPanel.this.attributesModel.removeElement(sourceIndex);
                        this.doAdd(temp);
                        attributeList.setSelectedIndex(this.getBorder());
                    }
                }
            }

            private boolean isValidOrBorder(int index) {
                return this.isValid(index) || index == this.getBorder();
            }

            private int getIncrement() {
                return this.up ? 1 : -1;
            }

            private void doAdd(XOUserObject temp) {
                if (this.up) {
                    AttributeSelectionPanel.this.attributesModel.insertElementAt(temp, 0);
                } else {
                    AttributeSelectionPanel.this.attributesModel.addElement(temp);
                }
            }

            protected int getBorder() {
                return this.up ? 0 : AttributeSelectionPanel.this.attributesModel.getSize() - 1;
            }

            private boolean isValid(int index) {
                int border = this.getBorder();
                return this.up ? index > border : index < border;
            }

            private boolean shouldExchange(int sourceIndex, int targetIndex) {
                int result = targetIndex - sourceIndex;
                if (this.up) {
                    result = -result;
                }
                return result <= 1;
            }
        }
        result.add(new MoveAction(true));
        result.add(new MoveAction(false));
        return result;
    }

    private List<BaseAction> getTreeActions() {
        ArrayList<BaseAction> result = new ArrayList<BaseAction>();
        result.add(new BaseAction(DesignerMsg.SELECT_ALL){

            public void run() {
                AttributeSelectionPanel.this.root.setSelected(TreeNode.Selection.ALL);
            }
        });
        result.add(new BaseAction(DesignerMsg.INVERT_SELECTION){

            public void run() {
                AttributeSelectionPanel.this.root.reverseSelection();
            }
        });
        if (this.otherActions != null) {
            result.addAll(this.otherActions);
        }
        return result;
    }

    private AttributesCheckTree createTree(UiContainer parent) {
        AttributesCheckTree tree = new AttributesCheckTree(parent, this.xotd);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                CheckTreeNode node = (CheckTreeNode)e.getTreePath().getLastPathComponent();
                int[] indexes = e.getChildIndices();
                if (indexes != null) {
                    for (int index : indexes) {
                        this.notify((CheckTreeNode)node.getChildAt(index));
                    }
                } else {
                    this.notify(node);
                }
            }

            private void notify(CheckTreeNode node) {
                XOUserObject xouo = (XOUserObject)node.getUserObject();
                if (xouo.getType() == 3) {
                    if (node.getSelected() == TreeNode.Selection.NONE) {
                        if (AttributeSelectionPanel.this.attributesModel.contains(xouo)) {
                            AttributeSelectionPanel.this.attributesModel.removeElement(xouo);
                        }
                    } else if (!AttributeSelectionPanel.this.attributesModel.contains(xouo)) {
                        AttributeSelectionPanel.this.attributesModel.addElement(xouo);
                    }
                }
            }
        });
        tree.getRoot().expand();
        return tree;
    }

    private oracle.bpm.ui.List createList(MyListModel listModel, UiContainer parent) {
        return new oracle.bpm.ui.List(parent, (ListModel)listModel, ListSelectionMode.SINGLE_SELECTION);
    }

    private void build() {
        FormLayout layout = new FormLayout("default:grow, default:grow", "default:grow");
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cellConstraints = layout.createCellConstraints();
        Panel treePanel = new Panel((UiContainer)this);
        treePanel.setLayout((Layout)new BorderLayout());
        treePanel.setBorder((Border)new TitledBorder(ProjectMsg.ATTRIBUTES));
        builder.add((UiComponent)treePanel, cellConstraints.xy(1, 1, "fill, fill"));
        Panel orderPanel = new Panel((UiContainer)this);
        orderPanel.setLayout((Layout)new BorderLayout());
        builder.add((UiComponent)orderPanel, cellConstraints.xy(2, 1, "fill, fill"));
        this.attributesModel = new MyListModel();
        oracle.bpm.ui.List order = this.createList(this.attributesModel, (UiContainer)orderPanel);
        AttributesCheckTree tree = this.createTree((UiContainer)treePanel);
        this.root = tree.getRoot();
        orderPanel.add((UiComponent)order, (Object)"Center");
        orderPanel.setBorder((Border)new TitledBorder(ProjectMsg.ORDER));
        orderPanel.add((UiComponent)this.createPanel(orderPanel, this.getOrderActions(order)), (Object)"South");
        treePanel.add((UiComponent)tree, (Object)"Center");
        treePanel.add((UiComponent)this.createPanel(treePanel, this.getTreeActions()), (Object)"South");
    }

    private Panel createPanel(Panel parentPanel, List<BaseAction> actions) {
        Panel resultPanel = new Panel((UiContainer)parentPanel);
        if (actions != null) {
            for (BaseAction action : actions) {
                resultPanel.add((UiComponent)new Button((UiContainer)resultPanel, action));
            }
        }
        return resultPanel;
    }

    private void createDatas(CheckTreeNode root, String path, Hashtable groupedAtts, String[][] values, Hashtable innerXos) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> atts = new ArrayList<String>();
        for (TreeNode treeNode : root) {
            CheckTreeNode nextNode = (CheckTreeNode)treeNode;
            if (nextNode.getSelected() == TreeNode.Selection.NONE) continue;
            XOUserObject next = (XOUserObject)nextNode.getUserObject();
            if (next.type == 3) {
                atts.add(next.toString());
                continue;
            }
            if (next.type == 2) {
                groups.add(next.toString());
                ArrayList<String> temp = new ArrayList<String>();
                for (TreeNode node : nextNode) {
                    CheckTreeNode current = (CheckTreeNode)node;
                    if (current.getSelected() == TreeNode.Selection.NONE) continue;
                    temp.add(current.toString());
                }
                groupedAtts.put(next.toString(), temp);
                continue;
            }
            if (next.type != 1) continue;
            String name = next.toString();
            Hashtable inner2 = new Hashtable();
            String[][] values2 = new String[2][2];
            Hashtable grouped2 = new Hashtable();
            this.createDatas(nextNode, path + name + ".", grouped2, values2, inner2);
            ArrayList<Object> ar = new ArrayList<Object>();
            ar.add(values2[0]);
            ar.add(values2[1]);
            ar.add(grouped2);
            ar.add(inner2);
            innerXos.put(name, ar);
            atts.add(name);
        }
        values[1] = groups.toArray(new String[0]);
        values[0] = atts.toArray(new String[0]);
        Enumeration keys = groupedAtts.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            ArrayList s = (ArrayList)groupedAtts.get(key);
            groupedAtts.put(key, s.toArray(new String[0]));
        }
    }

    private int createMap(LinkedHashMap attr, XOUserObject[] orderedAttribures, int currentLine, String prefix) {
        int lastLineChecked = currentLine;
        while (lastLineChecked < orderedAttribures.length) {
            String currentPrefix = orderedAttribures[lastLineChecked].getPrefix();
            if (prefix.equals(currentPrefix)) {
                attr.put(orderedAttribures[lastLineChecked].member.getName(), null);
                ++lastLineChecked;
                continue;
            }
            if (currentPrefix.startsWith(prefix)) {
                int fromPos = prefix.length() == 0 ? 0 : prefix.length() + 1;
                int toPos = currentPrefix.indexOf(".", fromPos);
                if (toPos <= fromPos) {
                    toPos = currentPrefix.length();
                }
                String name = currentPrefix.substring(fromPos, toPos);
                String newPrefix = currentPrefix.substring(0, toPos);
                LinkedHashMap newAttr = new LinkedHashMap();
                lastLineChecked = this.createMap(newAttr, orderedAttribures, lastLineChecked, newPrefix);
                if (attr.get(name) != null) {
                    LinkedHashMap primerHash = (LinkedHashMap)attr.get(name);
                    primerHash.putAll(newAttr);
                    continue;
                }
                attr.put(name, newAttr);
                continue;
            }
            return lastLineChecked;
        }
        return lastLineChecked;
    }

    private static class MyListModel
    implements ListModel {
        private ArrayList<XOUserObject> elements = new ArrayList();
        private ArrayList<ListDataListener> listeners = new ArrayList();

        public boolean contains(XOUserObject xouo) {
            return this.elements.contains(xouo);
        }

        public void setElementAt(XOUserObject object, int i) {
            this.elements.set(i, object);
            this.notifyAdded(i);
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(new ListDataEvent(this, 0, i, i));
            }
        }

        public XOUserObject[] toArray() {
            XOUserObject[] orderedAttribures = new XOUserObject[this.elements.size()];
            orderedAttribures = this.elements.toArray(orderedAttribures);
            return orderedAttribures;
        }

        public void insertElementAt(XOUserObject object, int i) {
            this.elements.add(i, object);
            this.notifyAdded(i);
        }

        public void addElement(XOUserObject e) {
            this.elements.add(e);
            int size = this.elements.size();
            this.notifyAdded(size);
        }

        public void removeElement(int index) {
            this.removeElement(this.elements.get(index));
        }

        public void removeElement(XOUserObject e) {
            this.elements.remove(e);
            int size = this.elements.size();
            for (ListDataListener listener : this.listeners) {
                listener.intervalRemoved(new ListDataEvent(this, 2, size, size + 1));
            }
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        public Object getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        private void notifyAdded(int location) {
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(new ListDataEvent(this, 1, location - 1, location));
            }
        }
    }
}

