/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.formdesigner;

import java.util.ArrayList;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.action.SaveAction;
import oracle.bpm.designer.formdesigner.ChangeListener;
import oracle.bpm.designer.formdesigner.actions.FormDesignerActions;
import oracle.bpm.designer.formdesigner.command.Command;
import oracle.bpm.designer.formdesigner.editors.EditorRegistry;
import oracle.bpm.designer.formdesigner.outline.DataTreeHelper;
import oracle.bpm.designer.formdesigner.outline.PresentationStructureView;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.xml.XFormXMLObject;

public abstract class AbstractPresentationEditor
extends CatalogObjectEditor
implements oracle.bpm.ui.event.ChangeListener,
SelectionProvider,
ChangeListener {
    private EditorRegistry editorRegistry;
    private FormDesignerActions formDesignerActions;
    private DataTreeHelper helper;
    private XFormPresentationModel originalPresentationModel;
    private SelectionWrapper selectionHandler = new SelectionWrapper();

    public AbstractPresentationEditor(UiContainer parent, XFormPresentationModel presentation) {
        super(parent, AbstractPresentationEditor.getCatalogObject(presentation));
        this.setModel(presentation);
        this.init();
    }

    public abstract void requestFocusOn(XFormXMLObject var1, boolean var2);

    public abstract boolean doIgnoringEvents(Command var1);

    public abstract boolean undoIgnoringEvents(Command var1);

    @Override
    public void changeOccured(ChangeListener.ChangeEvent change) {
        this.setDirty(true);
        if (!this.isDisposed()) {
            this.applyChanges(change);
        }
    }

    public DataTreeHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DataTreeHelper(this.getModel());
        }
        return this.helper;
    }

    public final Selection getSelection() {
        return this.selectionHandler.getSelection();
    }

    public void setSelection(Selection selection) {
        this.selectionHandler.setSelection(selection);
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.selectionHandler.addSelectionListener(listener);
    }

    @Override
    public final void removeSelectionListener(SelectionListener listener) {
        this.selectionHandler.removeSelectionListener(listener);
    }

    public final void setSelectionProvider(SelectionProvider delegate) {
        this.selectionHandler.setDelegate(delegate);
    }

    @Override
    public Image getIcon() {
        XObjectTypeDescription object = (XObjectTypeDescription)this.getObjectTypeDescription();
        assert (object != null) : "Null owner";
        return IconFactory.getIconFor(this.originalPresentationModel, object);
    }

    public ObjectTypeDescription getObjectTypeDescription() {
        return this.originalPresentationModel.getOwner();
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.PRESENTATION;
    }

    public XFormPresentationModel getModel() {
        return this.originalPresentationModel;
    }

    @Override
    public String getTitle() {
        return this.originalPresentationModel.getModelName();
    }

    @Override
    public Object getInput() {
        return this.getModel();
    }

    @Override
    public boolean close() {
        if (this.isDirty()) {
            if (!new SaveAction(this).doIt()) {
                return false;
            }
            this.setDirty(false);
        }
        this.originalPresentationModel = null;
        return super.close();
    }

    public EditorRegistry getEditorRegistry() {
        return this.editorRegistry;
    }

    public FormDesignerActions getActions() {
        return this.formDesignerActions;
    }

    protected abstract void applyChanges(ChangeListener.ChangeEvent var1);

    protected abstract Panel createContainerPanel(UiContainer var1);

    @Override
    protected void objectHasChanged() {
        this.helper.recalculateMethods();
    }

    @Override
    protected void replaceObject() {
    }

    @Override
    protected final void buildUI(UiContainer parent) {
        parent.setLayout((Layout)new BorderLayout());
        this.editorRegistry = EditorRegistry.create();
        parent.add((UiComponent)this.createContainerPanel(parent), (Object)"Center");
    }

    protected void setModel(XFormPresentationModel model) {
        this.originalPresentationModel = model;
    }

    @Override
    protected void editorToObject() {
        System.out.println("AbstractPresentationEditor.editorToObject");
    }

    @Override
    protected void objectToEditor() {
    }

    protected FormDesignerActions getFormDesignerActions(PresentationStructureView viewCreator, ChangeListener listener) {
        if (this.formDesignerActions == null) {
            this.formDesignerActions = new FormDesignerActions(viewCreator, this, listener);
        }
        return this.formDesignerActions;
    }

    private static CatalogObject getCatalogObject(XFormPresentationModel presentation) {
        assert (presentation != null) : "Presentation model cannot be null.";
        ObjectTypeDescription owner = presentation.getOwner();
        assert (owner != null) : "Presentation " + presentation.getName() + " has no owner.";
        FuegoProject project = FuegoProject.getFrom((TypeRef)owner);
        assert (project != null) : "ObjectTypeDescription " + owner + " does not belong to any project.";
        TypeRef ref = owner.getRef();
        assert (ref != null) : "ObjectTypeDescription " + owner + " has no TypeRef associated.";
        return CatalogObjectImpl.create((Project)project, (TypeRef)ref);
    }

    private static class SelectionWrapper
    implements SelectionProvider {
        private SelectionProvider delegate;
        private ArrayList<SelectionListener> listeners;

        private SelectionWrapper() {
        }

        public Selection getSelection() {
            return this.delegate == null ? null : this.delegate.getSelection();
        }

        public void setSelection(Selection selection) {
            if (this.delegate != null) {
                this.delegate.setSelection(selection);
            }
        }

        public void addSelectionListener(SelectionListener listener) {
            if (this.delegate != null) {
                this.delegate.addSelectionListener(listener);
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(listener);
            }
        }

        public void setDelegate(SelectionProvider delegate) {
            this.delegate = delegate;
            if (delegate != null && this.listeners != null) {
                for (SelectionListener listener : this.listeners) {
                    delegate.addSelectionListener(listener);
                }
                this.listeners = null;
            }
        }

        public void removeSelectionListener(SelectionListener listener) {
            if (this.delegate != null) {
                this.delegate.removeSelectionListener(listener);
            }
        }
    }
}

