/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fojsp.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.fojsp.actions.CreateFolderAction;
import oracle.bpm.designer.fojsp.actions.DeleteFolderAction;
import oracle.bpm.designer.fojsp.actions.ImportJSPAction;
import oracle.bpm.designer.fojsp.actions.ImportResourcesAction;
import oracle.bpm.designer.fojsp.tree.AbstractWebNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.resources.ResourceObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public class FolderNode
extends AbstractWebNode {
    private int allowedContent;
    private boolean loaded = false;

    public FolderNode(WebContainer webContainer) {
        super((ResourceObject)webContainer);
    }

    public WebContainer getFolderContent() {
        return (WebContainer)this.getContent();
    }

    @Override
    public Image resolveIcon() {
        this.nodeIcon = Image.create((Msg)DesignerMsg.FOLDER);
        return !this.isReadOnly() ? this.nodeIcon : IconFactory.createReadOnly(this.nodeIcon);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup actionGroup = new ActionGroup(DesignerMsg.FOLDER);
        actionGroup.addSeparator();
        CreateFolderAction createFolderAction = new CreateFolderAction();
        createFolderAction.setEnabled(!this.isReadOnly());
        actionGroup.add((BaseAction)createFolderAction);
        if ((this.getAllowedContent() & 0xE) == 14) {
            ImportResourcesAction importResourcesAction = new ImportResourcesAction(this);
            importResourcesAction.setEnabled(!this.isReadOnly());
            actionGroup.add((BaseAction)importResourcesAction);
        }
        if ((this.getAllowedContent() & 0x10) == 16) {
            ImportJSPAction importJSPAction = new ImportJSPAction(this);
            importJSPAction.setEnabled(!this.isReadOnly());
            actionGroup.add((BaseAction)importJSPAction);
        }
        this.addDeleteAction(actionGroup);
        actionGroup.add((BaseAction)super.createActions());
        return actionGroup;
    }

    public int getAllowedContent() {
        return this.allowedContent;
    }

    public void setAllowedContent(int allowedContent) {
        this.allowedContent = allowedContent;
    }

    @Override
    public DesignerAction getDeleteAction() {
        return new DeleteFolderAction(this);
    }
}

