/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fojsp.tree;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.fojsp.loaders.Loader;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.resources.ResourceObject;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;

public abstract class AbstractWebNode
extends ProjectObjectTreeNode<ResourceObject> {
    protected DesignerAction deleteAction;
    protected Loader loader;
    protected Image nodeIcon;
    protected Project project;
    static final long serialVersionUID = -3133646462771683866L;
    static final long serialCheck = -472453394556798391L;

    public AbstractWebNode(ResourceObject webRootObject) {
        super((ProjectObject)webRootObject);
        this.setUserObject(webRootObject);
        this.deleteAction = this.getDeleteAction();
        this.project = webRootObject.getProject();
    }

    public abstract DesignerAction getDeleteAction();

    public ResourceObject getContent() {
        return (ResourceObject)this.getUserObject();
    }

    public void setLoader(Loader loader) {
        this.loader = loader;
    }

    @Override
    public String getName() {
        return this.getContent().getName();
    }

    public boolean isRemovable() {
        return !((ResourceObject)this.getProjectObject()).isDefault();
    }

    public boolean delete() {
        return this.isRemovable() && this.deleteAction.doIt();
    }

    @Override
    public String toString() {
        return this.getContent().getName();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    protected ActionGroup getRootAction() {
        return new ActionGroup(DesignerMsg.EMPTY_MSG(""));
    }

    protected boolean isReadOnly() {
        return this.getContent().isReadOnly();
    }

    protected void addCommonActions() {
        super.addCommonActions();
        if (this.isRemovable()) {
            this.getCommonActionsMap().put("delete-action", this.deleteAction);
        }
    }

    protected void addDeleteAction(ActionGroup action) {
        if (this.isRemovable()) {
            DesignerAction deleteAction = this.deleteAction;
            deleteAction.setEnabled(!this.isReadOnly());
            action.add((BaseAction)deleteAction);
        }
    }
}

