/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fojsp.actions;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.fojsp.tree.FolderNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;

public class DeleteFolderAction
extends DesignerAction {
    private FolderNode folderNode;
    static final long serialVersionUID = -1318116638054304113L;
    static final long serialCheck = -7754184464361581761L;

    public DeleteFolderAction(FolderNode folderNode) {
        super(UIMsg.MENU_DELETE);
        this.requires(WebContainer.class);
        this.setSelection(folderNode.getSelection());
        this.folderNode = folderNode;
    }

    @Override
    public boolean doIt() {
        boolean result;
        int answer = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.DELETE_FOLDER, (Msg)DesignerMsg.CONFIRM_DELETE_FOLDER(this.folderNode.getContent().getName()), null, (int)6, null);
        boolean bl = result = answer == 2;
        if (result) {
            result = this.deleteWebContainer();
        }
        return result;
    }

    public void unDoIt() {
    }

    private boolean deleteWebContainer() {
        try {
            WebContainer folder = (WebContainer)this.getSelection().as(WebContainer.class);
            folder.getParent().asMutable().removeContainer((Container)folder);
        }
        catch (ProjectException e) {
            Log.logDebug(e);
            return false;
        }
        return true;
    }
}

