/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.fojsp.actions;

import java.io.File;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.fojsp.tree.FolderNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.fojsp.WebContainer;
import oracle.bpm.project.model.fojsp.WebContent;
import oracle.bpm.project.model.fojsp.WebContentType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.util.FileUtils;

public abstract class AbstractImportAction
extends DesignerAction {
    protected FolderNode folderNode;
    static final long serialVersionUID = 6684729653404200385L;
    static final long serialCheck = 4426749433564757893L;

    public AbstractImportAction(Msg msg, FolderNode folderNode) {
        super(msg);
        this.folderNode = folderNode;
        this.requires(WebContainer.class);
    }

    public void addFiles(File[] filesSelected) {
        for (File fileSelected : filesSelected) {
            if (!this.fileAlreadyImported(fileSelected)) {
                this.addFileSelected(fileSelected);
                continue;
            }
            if (!this.wantOverride()) continue;
            this.overrideFile(fileSelected);
        }
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        FileChooser fileChooser = new FileChooser();
        this.addFilters(fileChooser);
        int status = fileChooser.showOpenDialog((UiComponent)Ui.getRoot(), 1);
        File[] filesToCopy = fileChooser.getSelectedFiles();
        if (status == 0) {
            try {
                this.addFiles(filesToCopy);
                result = true;
            }
            catch (ReadOnlyException e) {
                throw e;
            }
            catch (Exception e) {
                Log.logInfo(e);
                result = false;
            }
        }
        return result;
    }

    protected abstract void addFilters(FileChooser var1);

    private void overrideFile(File fileSelected) {
        try {
            WebContainer.Mutable parent = ((WebContainer.Mutable)this.getSelection().as(WebContainer.Mutable.class)).asMutable();
            ProjectWriter writer = parent.getProject().getWriter();
            writer.write(new ProjectObject[]{this.createWebContent(fileSelected)});
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private boolean wantOverride() {
        int answer = MessageDialog.showQuestion((UiContainer)null, (Msg)DesignerMsg.FILE_ALREADY_IMPORTED, (Msg)DesignerMsg.FILE_ALREADY_IMPORTED_MSG, null, (int)6, null);
        return answer == 2;
    }

    private boolean fileAlreadyImported(File fileSelected) {
        WebContainer.Mutable parent = ((WebContainer.Mutable)this.getSelection().as(WebContainer.Mutable.class)).asMutable();
        String fileExtension = FileUtils.getExtension(fileSelected);
        String fileName = FileUtils.getName(fileSelected);
        return parent.findWebContent(fileName, WebContentType.valueOfFileExtension((String)fileExtension)) != null;
    }

    private void addFileSelected(File fileSelected) {
        String fileName = FileUtils.getName(fileSelected);
        WebContainer.Mutable parent = ((WebContainer.Mutable)this.getSelection().as(WebContainer.Mutable.class)).asMutable();
        try {
            if (fileSelected.isDirectory()) {
                Container.Mutable folder = parent.createContainer(fileName);
                parent.addContainer((Container)folder);
            } else {
                WebContent.Mutable webContent = this.createWebContent(fileSelected);
                parent.addWebContent((WebContent)webContent);
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private WebContent.Mutable createWebContent(File fileSelected) {
        String fileExtension = FileUtils.getExtension(fileSelected);
        String fileName = FileUtils.getName(fileSelected);
        WebContainer.Mutable parent = ((WebContainer.Mutable)this.getSelection().as(WebContainer.Mutable.class)).asMutable();
        WebContent.Mutable webContent = parent.createWebContent(fileName, WebContentType.valueOfFileExtension((String)fileExtension));
        webContent.setSourceDir(fileSelected.getPath());
        return webContent;
    }
}

