/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.conversation.ReferenceComboBox;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.PriorityCombo;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ReinitiatePolicy;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class UserTaskPreferencesEditor
extends AbstractCompositeEditor {
    public UserTaskPreferencesEditor(UserTask userTask) {
        super(DesignerMsg.HUMAN_TASK_ATTRIBUTES, (FlowNode)userTask);
    }

    public UserTask getFlowNode() {
        return (UserTask)super.getFlowNode();
    }

    @Override
    public boolean isCollapsed() {
        return false;
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>();
        result.add(new PreferencesEditor(this.getFlowNode()));
        return result;
    }

    private static class PreferencesEditor
    extends FlowNodePropertiesEditor {
        private PreferencesEditorBuilder builder;

        public PreferencesEditor(UserTask userTask) {
            this.builder = new PreferencesEditorBuilder(userTask);
        }

        @Override
        public void applyChanges() {
            this.builder.applyChanges();
        }

        @Override
        public EditorBuilder getEditorBuilder() {
            return this.builder;
        }

        @Override
        public void validate() throws ProjectException {
            this.builder.validate();
        }

        private static class ReinitiatePanel
        extends Panel {
            private CheckBox clearPayloadCheckBox;
            private CheckBox reinitiateCheckBox;
            private ReferenceComboBox<UserTask> sourceCombobox;
            private UserTask userTask;

            public ReinitiatePanel(UiContainer parent, UserTask userTask) {
                super(parent);
                this.userTask = userTask;
                this.init();
            }

            public void applyChanges() {
                boolean isReinitiate = this.reinitiateCheckBox.isSelected();
                this.userTask.setReinitiate(isReinitiate);
                ReinitiatePolicy policy = isReinitiate && this.clearPayloadCheckBox.isSelected() ? ReinitiatePolicy.CLEAR_PAYLOAD : ReinitiatePolicy.REUSE_PAYLOAD;
                this.userTask.setReinitiatePolicy(policy);
                UserTask source = isReinitiate ? this.sourceCombobox.getValue() : null;
                this.userTask.setReinitiateSource(source);
            }

            public void validateData() throws ProjectException {
                if (this.reinitiateCheckBox.isSelected() && (!this.sourceCombobox.isValidSelection() || this.sourceCombobox.getValue() == null)) {
                    throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_REINITITE_SOURCE);
                }
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("hidemode 3, ins 0, gap 5, fillx"));
                this.reinitiateCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.RE_INITIATE);
                boolean isReinitiate = this.userTask.isReinitiate();
                this.reinitiateCheckBox.setSelected(isReinitiate);
                this.sourceCombobox = this.createReinitiateSourceComboBox((UiContainer)this, this.userTask);
                this.sourceCombobox.setValue(this.userTask.getReinitiateSource());
                this.clearPayloadCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.CLEAR_PAYLOAD_DSC);
                boolean isClear = isReinitiate && this.userTask.getReinitiatePolicy().isClear();
                this.clearPayloadCheckBox.setSelected(isClear);
                this.clearPayloadCheckBox.setVisible(isReinitiate);
                this.sourceCombobox.setVisible(isReinitiate);
                this.reinitiateCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        boolean enabled = e.isStateSelected();
                        ReinitiatePanel.this.clearPayloadCheckBox.setVisible(enabled);
                        ReinitiatePanel.this.sourceCombobox.setVisible(enabled);
                    }
                });
                this.add((UiComponent)this.reinitiateCheckBox);
                this.add((UiComponent)this.sourceCombobox, "growx, wrap");
                this.add((UiComponent)this.clearPayloadCheckBox, "spanx, wrap");
            }

            private ReferenceComboBox<UserTask> createReinitiateSourceComboBox(@NotNull UiContainer parent, @NotNull UserTask userTask) {
                ReferenceComboBox<UserTask> result = new ReferenceComboBox<UserTask>(parent);
                Sequence sources = userTask.getProcess().getDescendants(UserTask.class);
                for (UserTask source : sources) {
                    if (ModelUtils.isSameObjectId((ProjectObject)userTask, (ProjectObject)source)) continue;
                    result.addItem(source);
                }
                result.setLabelProvider((LabelProvider)new LabelProvider<UserTask>(){

                    public Image getIcon(UserTask element) {
                        return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
                    }

                    public String getText(UserTask element) {
                        return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
                    }
                });
                return result;
            }
        }

        private static class PreferencesEditorBuilder
        extends DefaultEditorBuilder {
            private ArrayList<EditorBuilder.RowBuilder> builders;
            private PriorityCombo priorityCombo;
            private ReinitiatePanel reinitiatePanel;
            private ExpressionPanel titleExpression;
            private UserTask userTask;

            public PreferencesEditorBuilder(final UserTask userTask) {
                this.userTask = userTask;
                this.builders = new ArrayList();
                this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.TITLE){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.titleExpression = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                        PreferencesEditorBuilder.this.titleExpression.setExpression(userTask.getSubject());
                        return PreferencesEditorBuilder.this.titleExpression;
                    }
                });
                this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.VAR_PRIORITY_KEY){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.priorityCombo = new PriorityCombo(parent);
                        int i = userTask.getPriority();
                        if (i > 0) {
                            PreferencesEditorBuilder.this.priorityCombo.setSelectedItem(i);
                        }
                        PreferencesEditorBuilder.this.priorityCombo.addItemListener(new ItemListener(){

                            public void itemStateChanged(ItemEvent e) {
                                PreferencesEditorBuilder.this.applyPriority();
                            }
                        });
                        return PreferencesEditorBuilder.this.priorityCombo;
                    }

                    @Override
                    public boolean isGrowX() {
                        return false;
                    }
                });
                this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EMPTY_MSG("")){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        PreferencesEditorBuilder.this.reinitiatePanel = new ReinitiatePanel(parent, userTask);
                        return PreferencesEditorBuilder.this.reinitiatePanel;
                    }
                });
            }

            @Override
            public List<EditorBuilder.RowBuilder> getBuilders() {
                return this.builders;
            }

            public void applyChanges() {
                this.userTask.setSubject(this.titleExpression.getExpression());
                this.applyPriority();
                this.reinitiatePanel.applyChanges();
            }

            public void validate() throws ProjectException {
                if (!this.titleExpression.isValid()) {
                    throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(DesignerMsg.TITLE.getString()));
                }
                this.reinitiatePanel.validateData();
            }

            private void applyPriority() {
                this.userTask.setPriority(((Integer)this.priorityCombo.getSelectedItem()).intValue());
            }
        }
    }
}

