/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.designer.HumanTaskService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.SoaObjectRowEditorBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;

class UserTaskEditor
extends FlowNodePropertiesEditor {
    private UserTaskImplementationEditorBuilder builder;

    public UserTaskEditor(UserTask userTask) {
        this.builder = new UserTaskImplementationEditorBuilder(userTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class UserTaskImplementationEditorBuilder
    extends DefaultEditorBuilder {
        private HumanTask humanTask;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();
        private UserTask userTask;

        public UserTaskImplementationEditorBuilder(final UserTask userTask) {
            this.userTask = userTask;
            this.humanTask = userTask.getHumanTask();
            StudioWorkbench workbech = AbstractStudioWorkbench.getInstance();
            final HumanTaskService service = workbech.getHumanTaskService();
            HumanTaskType humanTaskTypeFilter = null;
            if (!userTask.getHumanTaskType().isDefault() && this.humanTask == null) {
                humanTaskTypeFilter = userTask.getHumanTaskType();
            }
            ProjectFilters.HumanTaskFilter humanTaskFilter = ProjectFilters.HumanTaskFilter.create(humanTaskTypeFilter);
            SoaObjectRowEditorBuilder<HumanTask> catalogObjectRowEditorBuilder = new SoaObjectRowEditorBuilder<HumanTask>(ProjectModelMsg.HUMAN_TASK, userTask.getProject(), (ProjectFilter)humanTaskFilter, this.humanTask){

                @Override
                protected void change(HumanTask newValue) {
                    UserTaskImplementationEditorBuilder.this.humanTask = newValue;
                    UserTaskImplementationEditorBuilder.this.applyChanges();
                }

                @Override
                public Image getCatalogObjectIcon(@NotNull HumanTask newValue) {
                    Image result = null;
                    HumanTaskType humanTaskType = newValue.getHumanTaskType();
                    if (humanTaskType != null) {
                        result = UserTaskImplementationEditorBuilder.getImage(humanTaskType);
                    }
                    return result;
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_HUMAN_TASKS;
                }

                @Override
                protected void addAction(UiWindow parent) {
                    URL url;
                    HumanTask newHumanTask;
                    int defaultPririty = userTask.getPriority();
                    HumanTaskPreferences humanTaskPreferences = new HumanTaskPreferences(defaultPririty);
                    humanTaskPreferences.setPriority(userTask.getPriority());
                    HumanTaskData humanTaskData = service.createHumanTask(parent, userTask, humanTaskPreferences);
                    if (humanTaskData != null && (newHumanTask = this.findCatalogObjectFromUrl(url = humanTaskData.getUrl(), HumanTask.class)) != null) {
                        this.changeValue(newHumanTask);
                        if (!newHumanTask.getHumanTaskType().isInitiator()) {
                            1.changeInputDataAssociation(userTask.getInputDataAssociationSet(), humanTaskData.getInputParameters());
                        }
                        1.changeOutputDataAssociation(userTask.getOutputDataAssociationSet(), humanTaskData.getOutputParameters());
                    }
                }
            };
            this.rowBuilders.add(catalogObjectRowEditorBuilder);
        }

        public void applyChanges() {
            try {
                this.userTask.setHumanTask(this.humanTask);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        private static Image getImage(HumanTaskType humanTaskType) {
            HumanTaskType type = humanTaskType == null ? HumanTaskType.SIMPLE : humanTaskType;
            FlowFigureType flowFigureType = FlowFigureUtils.fromUserTask((HumanTaskType)type);
            DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
            return theme.getImageFor(flowFigureType, ImageType.MINI_ICON);
        }
    }
}

