/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class UserTaskAdvancedEditor
extends FlowNodePropertiesEditor {
    private UserTaskEditorBuilder builder;

    public UserTaskAdvancedEditor(UserTask userTask) {
        this.builder = new UserTaskEditorBuilder(userTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validate();
    }

    private static class UserTaskEditorBuilder
    extends DefaultEditorBuilder {
        private ExpressionPanel applicationContextField;
        private List<EditorBuilder.RowBuilder> builders;
        private ExpressionPanel identificationContextField;
        private ExpressionPanel identificationKeyField;
        private ExpressionPanel initiatorField;
        private ExpressionPanel ownerField;
        private UserTask userTask;

        public UserTaskEditorBuilder(final UserTask userTask) {
            this.userTask = userTask;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.INITIATOR){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.initiatorField = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                    UserTaskEditorBuilder.this.initiatorField.setExpression(userTask.getInitiator());
                    return UserTaskEditorBuilder.this.initiatorField;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.OWNER){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.ownerField = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                    UserTaskEditorBuilder.this.ownerField.setExpression(userTask.getOwner());
                    return UserTaskEditorBuilder.this.ownerField;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.ID_KEY){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.identificationKeyField = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                    UserTaskEditorBuilder.this.identificationKeyField.setExpression(userTask.getIdentificationKey());
                    return UserTaskEditorBuilder.this.identificationKeyField;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.ID_CONTEXT){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.identificationContextField = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                    UserTaskEditorBuilder.this.identificationContextField.setExpression(userTask.getIdentificationContext());
                    return UserTaskEditorBuilder.this.identificationContextField;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectModelMsg.APP_CONTEXT){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UserTaskEditorBuilder.this.applicationContextField = ExpressionPanel.createWithComboSelector(parent, (DataDeclarationContainer)userTask, CatalogType.Default.getString());
                    UserTaskEditorBuilder.this.applicationContextField.setExpression(userTask.getApplicationContext());
                    return UserTaskEditorBuilder.this.applicationContextField;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.userTask.setInitiator(this.initiatorField.getExpression());
            this.userTask.setOwner(this.ownerField.getExpression());
            this.userTask.setIdentificationKey(this.identificationKeyField.getExpression());
            this.userTask.setIdentificationContext(this.identificationContextField.getExpression());
            this.userTask.setApplicationContext(this.applicationContextField.getExpression());
        }

        public void validate() throws ProjectException {
            if (!this.initiatorField.isValid()) {
                throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.INITIATOR.getString()));
            }
            if (!this.ownerField.isValid()) {
                throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.OWNER.getString()));
            }
            if (!this.identificationKeyField.isValid()) {
                throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.ID_KEY.getString()));
            }
            if (!this.identificationContextField.isValid()) {
                throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.ID_CONTEXT.getString()));
            }
            if (!this.applicationContextField.isValid()) {
                throw new ProjectException((ProjectObject)this.userTask, DesignerMsg.INVALID_ATTRIBUTE_EXPRESSION(ProjectModelMsg.APP_CONTEXT.getString()));
            }
        }
    }
}

