/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.TimerEventType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioTabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TimeField;

class TimerEventEditor
extends FlowNodePropertiesEditor {
    private TimerEventEditorBuilder builder;

    public TimerEventEditor(Event event) {
        this.builder = new TimerEventEditorBuilder(event);
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validatePanel();
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class TimerRowEditorBuilder
    extends DefaultRowEditorBuilder {
        private ChangeEditorPanel changeTimeCycleEditor;
        private ChangeEditorPanel changeTimeDateEditor;
        private Event event;
        private RadioTabbedPane radioTabbedPane;
        private static final int TIME_DATE_INDEX = 0;
        private static final int TIME_CYCLE_INDEX = 1;

        public TimerRowEditorBuilder(Event event) {
            super(null);
            this.event = event;
        }

        public void validatePanel() throws ProjectException {
            if (this.radioTabbedPane.getSelectedIndex() == 1) {
                this.changeTimeCycleEditor.validatePanel();
            } else if (this.radioTabbedPane.getSelectedIndex() == 0) {
                this.changeTimeDateEditor.validatePanel();
            }
        }

        @Override
        public UiComponent createEditor(UiContainer parent) {
            this.radioTabbedPane = new RadioTabbedPane(parent);
            UiContainer uiContainer = this.radioTabbedPane.getAddPoint();
            this.changeTimeDateEditor = ChangeEditorPanel.createForTimeDate(uiContainer, this.event);
            this.changeTimeCycleEditor = ChangeEditorPanel.createForTimeCycle(uiContainer, this.event);
            this.radioTabbedPane.addTab(ProjectModelMsg.TIME_DATE, (UiComponent)this.changeTimeDateEditor);
            this.radioTabbedPane.addTab(ProjectModelMsg.TIME_CYCLE, (UiComponent)this.changeTimeCycleEditor);
            boolean isTimeCycle = this.getTimerEventDefinition().getType().equals((Object)TimerEventType.TIME_CYCLE);
            this.radioTabbedPane.setSelectedIndex(isTimeCycle ? 1 : 0);
            return this.radioTabbedPane;
        }

        public ChangeEditorPanel getActiveChangeEditorPanel() {
            return this.isTimeDate() ? this.changeTimeDateEditor : this.changeTimeCycleEditor;
        }

        Event getEvent() {
            return this.event;
        }

        private TimerEventDefinition getTimerEventDefinition() {
            EventDefinition eventDefinition = this.getEvent().getEventDefinition();
            return (TimerEventDefinition)eventDefinition.as(TimerEventDefinition.class);
        }

        private boolean isTimeDate() {
            return this.radioTabbedPane.getSelectedIndex() == 0;
        }

        private static class CardPanel
        extends Panel {
            private String activateKey;
            private Map<String, ValueEventEditor> editors = new HashMap<String, ValueEventEditor>();
            private static final String DEFAULT_EDITOR = "DefaultEditor";
            private static final String EXPRESSION_EDITOR = "ExpressionEditor";

            public CardPanel(UiContainer parent) {
                super(parent);
                this.setLayout((Layout)new CardLayout());
            }

            public UiComponent add(ValueEventEditor editor, String key) {
                this.activateKey = key;
                this.editors.put(key, editor);
                return super.add((UiComponent)editor, (Object)key);
            }

            public CardLayout getLayout() {
                return (CardLayout)super.getLayout();
            }

            public void show(String key) {
                this.getLayout().show((UiContainer)this, key);
                this.activateKey = key;
            }

            public boolean isExpression() {
                return EXPRESSION_EDITOR.equals(this.activateKey);
            }

            public ValueEventEditor getActivateEditor() {
                return this.editors.get(this.activateKey);
            }
        }

        private static abstract class ValueEventEditor<E>
        extends Panel {
            ValueEventEditor(UiContainer parent) {
                super(parent);
            }

            public abstract void applyValue(TimerEventDefinition var1);

            public abstract UiComponent createEditor(UiContainer var1, E var2);

            public static ValueEventEditor createExpresionForTimeDate(UiContainer parent, Process process, Expression value) {
                return new ExpressionEditor(parent, process, true, value);
            }

            public static ValueEventEditor createExpresionForTimeCycle(UiContainer parent, Process process, Expression value) {
                return new ExpressionEditor(parent, process, false, value);
            }

            public static ValueEventEditor createTime(UiContainer parent, Time value) {
                return new TimeEditor(parent, value);
            }

            public static ValueEventEditor createInterval(UiContainer parent, Interval value) {
                return new IntervalEditor(parent, value);
            }

            protected void init(E value) {
                this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
                this.add(this.createEditor((UiContainer)this, value), "growx");
            }

            abstract void validateEditor() throws ProjectException;

            private static class TimeEditor
            extends ValueEventEditor<Time> {
                private TimeField timeField;

                TimeEditor(UiContainer parent, Time value) {
                    super(parent);
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    timerEventDefinition.setTimeDateExpression((Expression)XPathExpression.createConstantExpression(this.getValue().toXMLString()));
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Time value) {
                    this.timeField = new TimeField(parent);
                    if (value != null) {
                        this.timeField.setTime(value);
                    }
                    return this.timeField;
                }

                @Override
                void validateEditor() throws ProjectException {
                }

                private Time getValue() {
                    return this.timeField.getTime();
                }
            }

            private static class IntervalEditor
            extends ValueEventEditor<Interval> {
                private IntervalField intervalField;

                IntervalEditor(UiContainer parent, Interval value) {
                    super(parent);
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    timerEventDefinition.setTimeCycleExpression((Expression)XPathExpression.createConstantExpression(this.getValue().toXMLString()));
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Interval value) {
                    this.intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent);
                    if (value != null) {
                        this.intervalField.setInterval(value);
                    }
                    return this.intervalField;
                }

                @Override
                void validateEditor() throws ProjectException {
                }

                private Interval getValue() {
                    return this.intervalField.getInterval();
                }
            }

            private static class ExpressionEditor
            extends ValueEventEditor<Expression> {
                private ExpressionPanel expressionPanel;
                private boolean isTimeDate;
                private Process process;

                ExpressionEditor(UiContainer parent, Process process, boolean isTimeDate, Expression value) {
                    super(parent);
                    this.process = process;
                    this.isTimeDate = isTimeDate;
                    this.init(value);
                }

                @Override
                public void applyValue(TimerEventDefinition timerEventDefinition) {
                    if (this.isTimeDate) {
                        timerEventDefinition.setTimeDateExpression(this.expressionPanel.getExpression());
                    } else {
                        timerEventDefinition.setTimeCycleExpression(this.expressionPanel.getExpression());
                    }
                }

                @Override
                public UiComponent createEditor(UiContainer parent, Expression expression) {
                    Panel panel = new Panel(parent);
                    panel.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
                    CatalogType resultType = this.isTimeDate ? CatalogType.Default.getTime() : CatalogType.Default.getInterval();
                    this.expressionPanel = ExpressionPanel.createWithRadioSelector((UiContainer)panel, (DataDeclarationContainer)this.process, resultType);
                    this.expressionPanel.setExpression(expression);
                    panel.add((UiComponent)this.expressionPanel, (Object)"growx");
                    return panel;
                }

                @Override
                public void validateEditor() throws ProjectException {
                    Expression expression = this.expressionPanel.getExpression();
                    if (!this.expressionPanel.isValid()) {
                        throw new ProjectException((ProjectObject)this.process, DesignerMsg.INVALID_EXPRESSION);
                    }
                    if (expression == null || Str.isEmpty(expression.getExpressionValue())) {
                        throw new ProjectException((ProjectObject)this.process, ProjectCompileMsg.EMPTY_EXPRESSION_NOT_ALLOWED);
                    }
                }
            }
        }

        private static abstract class ChangeEditorPanel
        extends Panel {
            CheckBox checkBox;
            private CardPanel cardPanel;
            private Event event;
            private TimerEventDefinition timerEventDefinition;

            public ChangeEditorPanel(UiContainer parent, Event event) {
                super(parent);
                this.event = event;
                this.timerEventDefinition = (TimerEventDefinition)event.getEventDefinition().as(TimerEventDefinition.class);
                this.init();
            }

            public abstract void validatePanel() throws ProjectException;

            public static ChangeEditorPanel createForTimeDate(UiContainer parent, Event event) {
                return new ChangeEditorPanelTimeDate(parent, event);
            }

            public static ChangeEditorPanel createForTimeCycle(UiContainer parent, Event event) {
                return new ChangeEditorPanelTimeCycle(parent, event);
            }

            public void applyValue(TimerEventDefinition timerEventDefinition) {
                this.cardPanel.getActivateEditor().applyValue(timerEventDefinition);
            }

            protected abstract void initCardPanel();

            protected CardPanel getCardPanel() {
                return this.cardPanel;
            }

            protected TimerEventDefinition getTimerEventDefinition() {
                return this.timerEventDefinition;
            }

            protected Process getProcess() {
                return this.event.getProcess();
            }

            private void init() {
                this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
                boolean isExpression = this.timerEventDefinition.isExpresion();
                this.checkBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.USE_EXPRESSION, (boolean)isExpression);
                this.checkBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        ChangeEditorPanel.this.show(e.isStateSelected());
                    }
                });
                this.cardPanel = new CardPanel((UiContainer)this);
                this.add((UiComponent)this.checkBox, "wrap");
                this.add((UiComponent)this.cardPanel, "growx, gapy 5");
                this.initCardPanel();
                this.show(isExpression);
            }

            private void show(boolean isExpression) {
                this.cardPanel.show(isExpression ? "ExpressionEditor" : "DefaultEditor");
            }

            private static class ChangeEditorPanelTimeDate
            extends ChangeEditorPanel {
                private ValueEventEditor expressionEditor;
                private ValueEventEditor timeEditor;

                public ChangeEditorPanelTimeDate(UiContainer parent, Event event) {
                    super(parent, event);
                }

                @Override
                public void validatePanel() throws ProjectException {
                    if (this.getCardPanel().isExpression()) {
                        this.expressionEditor.validateEditor();
                    } else {
                        this.timeEditor.validateEditor();
                    }
                }

                @Override
                protected void initCardPanel() {
                    Expression dateExpression;
                    Expression expression = null;
                    Time timeDateValue = null;
                    TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
                    boolean isTimeDate = timerEventDefinition.getType().equals((Object)TimerEventType.TIME_DATE);
                    if (isTimeDate && (dateExpression = timerEventDefinition.getTimeDateExpression()) != null) {
                        try {
                            timeDateValue = Time.valueOf(XPathExpression.fromXPathLiteral(dateExpression.getExpressionValue()));
                        }
                        catch (FormatException e) {
                            expression = dateExpression;
                        }
                    }
                    CardPanel cardPanel = this.getCardPanel();
                    this.timeEditor = ValueEventEditor.createTime((UiContainer)cardPanel, timeDateValue);
                    cardPanel.add(this.timeEditor, "DefaultEditor");
                    this.expressionEditor = ValueEventEditor.createExpresionForTimeDate((UiContainer)cardPanel, this.getProcess(), expression);
                    cardPanel.add(this.expressionEditor, "ExpressionEditor");
                }
            }

            private static class ChangeEditorPanelTimeCycle
            extends ChangeEditorPanel {
                private ValueEventEditor expressionEditor;
                private ValueEventEditor intervalEditor;

                public ChangeEditorPanelTimeCycle(UiContainer parent, Event event) {
                    super(parent, event);
                }

                @Override
                public void validatePanel() throws ProjectException {
                    if (this.getCardPanel().isExpression()) {
                        this.expressionEditor.validateEditor();
                    } else {
                        this.intervalEditor.validateEditor();
                    }
                }

                @Override
                protected void initCardPanel() {
                    Expression cycleExpression;
                    Expression expression = null;
                    Interval timeCycleValue = null;
                    TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
                    boolean isTimeCycle = timerEventDefinition.getType().equals((Object)TimerEventType.TIME_CYCLE);
                    if (isTimeCycle && (cycleExpression = timerEventDefinition.getTimeCycleExpression()) != null) {
                        try {
                            timeCycleValue = Interval.valueOf(XPathExpression.fromXPathLiteral(cycleExpression.getExpressionValue()));
                        }
                        catch (FormatException e) {
                            expression = cycleExpression;
                        }
                    }
                    CardPanel cardPanel = this.getCardPanel();
                    this.intervalEditor = ValueEventEditor.createInterval((UiContainer)cardPanel, timeCycleValue);
                    cardPanel.add(this.intervalEditor, "DefaultEditor");
                    this.expressionEditor = ValueEventEditor.createExpresionForTimeCycle((UiContainer)cardPanel, this.getProcess(), expression);
                    cardPanel.add(this.expressionEditor, "ExpressionEditor");
                }
            }
        }
    }

    private static class TimerEventEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private Event event;
        private TimerRowEditorBuilder timerEditorBuilder;

        public TimerEventEditorBuilder(Event event) {
            this.event = event;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.timerEditorBuilder = new TimerRowEditorBuilder(event);
            this.builders.add(this.timerEditorBuilder);
        }

        public Event getEvent() {
            return this.event;
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            TimerEventDefinition timerEventDefinition = this.getTimerEventDefinition();
            TimerRowEditorBuilder.ChangeEditorPanel panel = this.timerEditorBuilder.getActiveChangeEditorPanel();
            panel.applyValue(timerEventDefinition);
        }

        public void validatePanel() throws ProjectException {
            this.timerEditorBuilder.validatePanel();
        }

        private TimerEventDefinition getTimerEventDefinition() {
            EventDefinition eventDefinition = this.getEvent().getEventDefinition();
            return (TimerEventDefinition)eventDefinition.as(TimerEventDefinition.class);
        }
    }
}

