/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.net.URL;
import java.util.ArrayList;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.flowpanels.CatalogObjectRowEditorBuilder;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

abstract class SoaObjectRowEditorBuilder<E extends CatalogObject>
extends CatalogObjectRowEditorBuilder<E> {
    public SoaObjectRowEditorBuilder(Msg msg, Project project, ProjectFilter projectFilter, E value) {
        super(msg, project, projectFilter, value);
    }

    protected abstract void addAction(UiWindow var1);

    protected static void changeInputDataAssociation(DataAssociationSet inputAssociationSet, Sequence<Tuple<String, String>> inputParameters) {
        Sequence<DataAssociation> dataAssociations = SoaObjectRowEditorBuilder.createDataAssociation(inputAssociationSet, inputParameters);
        for (DataAssociation dataAssociation : dataAssociations) {
            inputAssociationSet.addDataAssociation(dataAssociation);
        }
    }

    protected static void changeOutputDataAssociation(DataAssociationSet outputAssociationSet, Sequence<Tuple<String, String>> outputParameters) {
        Sequence<DataAssociation> dataAssociations = SoaObjectRowEditorBuilder.createDataAssociation(outputAssociationSet, outputParameters);
        for (DataAssociation dataAssociation : dataAssociations) {
            outputAssociationSet.addDataAssociation(dataAssociation);
        }
    }

    @Override
    protected CatalogObjectRowEditorBuilder.CustomButtonsPosition getCustomButtonsPosition() {
        return CatalogObjectRowEditorBuilder.CustomButtonsPosition.BEGIN;
    }

    @Override
    protected Sequence<Button> createCustomButtons(UiContainer parent) {
        Button button = this.createAddButton(parent);
        ArrayList<Button> list = new ArrayList<Button>();
        list.add(button);
        return CollectionUtils.asSequence(list);
    }

    protected E findCatalogObjectFromUrl(URL url, Class<E> type) {
        CatalogObject result = null;
        Sequence objects = this.getProject().getCatalogRoot().getDescendants(type);
        for (CatalogObject catalogObject : objects) {
            Adaptable adaptable;
            URL url1;
            if (!(catalogObject instanceof Adaptable) || !url.equals(url1 = (adaptable = (Adaptable)catalogObject).as(URL.class))) continue;
            result = catalogObject;
            break;
        }
        return (E)result;
    }

    private static Sequence<DataAssociation> createDataAssociation(DataAssociationSet dataAssociationSet, Sequence<Tuple<String, String>> parameters) {
        ArrayList<DataAssociation> result = new ArrayList<DataAssociation>();
        for (Tuple<String, String> tupple : parameters) {
            String sourceName = tupple.getFirst();
            String targetName = tupple.getSecond();
            DataAssociation dataAssociation = SoaObjectRowEditorBuilder.createSimpleDataAssociation(dataAssociationSet, sourceName, targetName);
            result.add(dataAssociation);
        }
        return CollectionUtils.asSequence(result);
    }

    private static DataAssociation createSimpleDataAssociation(@NotNull DataAssociationSet dataAssociationSet, @NotNull String sourceString, @NotNull String targetString) {
        DataAssociationItemEndpoint targetEndpoint = DataAssociationItemEndpoint.TARGET;
        DataDeclarationContainer targetContext = dataAssociationSet.getContextProvider(targetEndpoint).getDataDeclarationContainer();
        Expression targetExpression = ExpressionHelper.createSimpleExpression((String)targetString, (DataDeclarationContainer)targetContext, null, null);
        DataAssociationItem targetItem = dataAssociationSet.createDataAssociationItem(targetEndpoint, targetExpression);
        CatalogType targetType = ExpressionHelper.getExpressionType((Expression)targetExpression, (DataDeclarationContainer)targetContext, null);
        DataAssociationItemEndpoint sourceEndpoint = DataAssociationItemEndpoint.SOURCE;
        DataDeclarationContainer sourceContext = dataAssociationSet.getContextProvider(sourceEndpoint).getDataDeclarationContainer();
        Expression sourceExpression = ExpressionHelper.createSimpleExpression((String)sourceString, (DataDeclarationContainer)sourceContext, (CatalogType)targetType, null);
        DataAssociationItem sourceItem = dataAssociationSet.createDataAssociationItem(sourceEndpoint, sourceExpression);
        return dataAssociationSet.createDataAssociation(sourceItem, targetItem);
    }

    private Button createAddButton(final UiContainer parent) {
        Button result = SoaObjectRowEditorBuilder.createButton(parent, UIMsg.ADD);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SoaObjectRowEditorBuilder.this.addAction(parent.getOwnerWindow());
            }
        });
        return result;
    }
}

