/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CollapsablePanel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

class PropertiesSheet {
    private List<Entry> entries = new ArrayList<Entry>();
    private Msg title;

    PropertiesSheet(Msg title) {
        this.title = title;
    }

    public void addCompositeEditor(AbstractCompositeEditor editor) {
        this.addCompositeEditor(null, editor);
    }

    public void addCompositeEditor(Msg msg, AbstractCompositeEditor editor) {
        this.entries.add(Entry.create(msg, editor));
    }

    public UiComponent buildEditor(UiContainer parent) {
        ScrollPane scroll = new ScrollPane(parent);
        UiComponent mainPanel = this.createEditors((UiContainer)scroll);
        scroll.setView(mainPanel);
        return scroll;
    }

    public Msg getTitle() {
        return this.title;
    }

    boolean shouldRender() {
        return !this.getShouldRenderEditors().isEmpty();
    }

    void validate() throws ProjectException {
        for (Entry entry : this.entries) {
            entry.getEditor().validate();
        }
    }

    void applyChanges() {
        for (Entry entry : this.entries) {
            entry.getEditor().applyChanges();
        }
    }

    private UiComponent createEditors(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout((Layout)new MigLayout("wrap, ins 5, gap 5, fillx"));
        List<Entry> editors = this.getShouldRenderEditors();
        int n = editors.size();
        for (int i = 0; i < n; ++i) {
            Entry entry = editors.get(i);
            boolean isFirst = i == 0;
            boolean isLast = i == n - 1;
            Object component = entry.getMsg() == null || isFirst ? entry.getEditor().buildEditor((UiContainer)mainPanel) : this.createCollapsable((UiContainer)mainPanel, entry);
            String constraints = "growx";
            constraints = constraints + (isLast ? ",growy" : "");
            mainPanel.add((UiComponent)component, (Object)constraints);
        }
        return mainPanel;
    }

    private CollapsablePanel createCollapsable(UiContainer parent, @NotNull Entry entry) {
        CollapsablePanel collapsable = new CollapsablePanel(parent, entry.getMsg(), entry.isCollapsed());
        Panel container = collapsable.getContainer();
        container.setLayout((Layout)new BorderLayout());
        container.add((UiComponent)entry.getEditor().buildEditor((UiContainer)container), (Object)"Center");
        return collapsable;
    }

    private List<Entry> getShouldRenderEditors() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (Entry entry : this.entries) {
            if (!entry.getEditor().shouldRender()) continue;
            result.add(entry);
        }
        return result;
    }

    private static class Entry {
        private AbstractCompositeEditor editor;
        private Msg msg;

        public Entry(Msg msg, AbstractCompositeEditor editor) {
            this.msg = msg;
            this.editor = editor;
        }

        public static Entry create(Msg msg, AbstractCompositeEditor editor) {
            return new Entry(msg, editor);
        }

        public AbstractCompositeEditor getEditor() {
            return this.editor;
        }

        public Msg getMsg() {
            return this.msg;
        }

        public boolean isCollapsed() {
            return this.editor.isCollapsed();
        }
    }
}

