/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import org.jetbrains.annotations.Nullable;

abstract class OperationRowEditorBuilder
extends DefaultRowEditorBuilder {
    private CatalogMember defaultOperation;
    private ComboBox<CatalogMember> operationCombo;
    private CatalogObject participant;

    public OperationRowEditorBuilder(Msg msg, CatalogObject participant, CatalogMember operation) {
        super(msg);
        this.participant = participant;
        this.defaultOperation = operation;
    }

    @Override
    public UiComponent createEditor(UiContainer parent) {
        this.operationCombo = UiFactory.createComboBox((UiContainer)parent);
        this.operationCombo.setLabelProvider((LabelProvider)new LabelProvider.Default<CatalogMember>(){

            public String getText(CatalogMember element) {
                return element != null ? element.getName() : "";
            }
        });
        this.operationCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OperationRowEditorBuilder.this.change(OperationRowEditorBuilder.this.getOperation());
            }
        });
        this.populateOperationCombo(this.defaultOperation);
        return this.operationCombo;
    }

    public CatalogMember getOperation() {
        return (CatalogMember)this.operationCombo.getSelectedItem();
    }

    public void setParticipant(CatalogObject participant) {
        this.participant = participant;
        this.populateOperationCombo(null);
    }

    protected abstract void change(CatalogMember var1);

    private void populateOperationCombo(@Nullable CatalogMember defaultOperation) {
        ArrayList<CatalogMember> values = new ArrayList<CatalogMember>();
        if (this.participant != null) {
            Sequence members = this.participant.getMethods();
            for (CatalogMember member : members) {
                if (member.isHidden()) continue;
                values.add(member);
            }
        }
        this.operationCombo.setModelList(values);
        if (!values.isEmpty()) {
            if (defaultOperation != null) {
                if (this.operationCombo.containsItem((Object)defaultOperation)) {
                    this.operationCombo.setSelectedItem((Object)defaultOperation);
                    this.change(defaultOperation);
                } else {
                    this.operationCombo.setSelectedIndex(-1);
                    this.change(null);
                }
            } else {
                this.operationCombo.setSelectedIndex(0);
                this.change((CatalogMember)this.operationCombo.getSelectedItem());
            }
        }
    }
}

