/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.compile.exceptions.ActivityHasNoNameException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TextHolder;

class NameAndDescriptionEditor
extends FlowNodePropertiesEditor {
    private NamePanelBuilder builder;

    public NameAndDescriptionEditor(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener sealTypeListener) {
        this.builder = new NamePanelBuilder(flowNode, sealTypeListener);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validate();
    }

    private static boolean isEmptyString(String str) {
        return str == null || "".equals(str.trim());
    }

    private static class NamePanelBuilder
    extends DefaultEditorBuilder {
        private ArrayList<EditorBuilder.RowBuilder> builders;
        private LocaleStringMap clonedDescription;
        private LocaleStringMap clonedLabel;
        private TextArea descriptionArea;
        private FlowNode flowNode;
        private TextField labelField;
        private ComboBox<ActivityPermissionType> permissionCombo;

        public NamePanelBuilder(final FlowNode flowNode, final AbstractFlowNodePropertiesPanel.ChangeTypeListener sealTypeListener) {
            this.flowNode = flowNode;
            this.builders = new ArrayList();
            this.builders.add(new DefaultRowEditorBuilder(ProjectDrawMsg.NAME){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel panel = new Panel(parent);
                    panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
                    NamePanelBuilder.this.labelField = new TextField((UiContainer)panel, 20);
                    NamePanelBuilder.this.labelField.setRequestFocusEnabled(true);
                    String defaultLabel = flowNode.getDefaultLabel();
                    if (!NameAndDescriptionEditor.isEmptyString(defaultLabel)) {
                        NamePanelBuilder.this.labelField.setText(defaultLabel);
                    } else {
                        NamePanelBuilder.this.labelField.setText(ModelUtils.generateDefaultLabel((FlowNode)flowNode));
                        NamePanelBuilder.this.labelField.selectAll();
                        NamePanelBuilder.this.labelField.requestFocus();
                    }
                    NamePanelBuilder.this.labelField.addDocumentListener(new DocumentListener(){

                        public void changedUpdate(DocumentEvent e) {
                            NamePanelBuilder.this.applyLabel();
                        }

                        public void insertUpdate(DocumentEvent e) {
                            NamePanelBuilder.this.applyLabel();
                        }

                        public void removeUpdate(DocumentEvent e) {
                            NamePanelBuilder.this.applyLabel();
                        }
                    });
                    DesignerResources.LocalizationProvider localizationProvider = new DesignerResources.LocalizationProvider(){

                        @Override
                        public LocaleStringMap getLocaleStringMap() {
                            return NamePanelBuilder.this.clonedLabel;
                        }

                        @Override
                        public TextHolder getTextHolder() {
                            return NamePanelBuilder.this.labelField;
                        }
                    };
                    DesignerResources.LocalizationButton localizationButton = DesignerResources.buildLocalizationButton(NamePanelBuilder.this.getProject(), (UiContainer)panel, localizationProvider, DesignerMsg.LOCALIZE_LABEL.getString());
                    NamePanelBuilder.this.clonedLabel = flowNode.getLabelMap().clone();
                    panel.add((UiComponent)NamePanelBuilder.this.labelField, (Object)"growx");
                    panel.add((UiComponent)localizationButton);
                    return panel;
                }
            });
            this.builders.add(new DefaultRowEditorBuilder(ProjectDrawMsg.DESCRIPTION){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel panel = new Panel(parent);
                    panel.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 0"));
                    NamePanelBuilder.this.descriptionArea = new TextArea((UiContainer)panel);
                    NamePanelBuilder.this.descriptionArea.setLineWrap(true);
                    NamePanelBuilder.this.descriptionArea.setRows(4);
                    NamePanelBuilder.this.descriptionArea.setWrapStyleWord(true);
                    String desc = flowNode.getDefaultDescription();
                    if (desc != null) {
                        NamePanelBuilder.this.descriptionArea.setText(desc);
                    }
                    DesignerResources.LocalizationProvider localizationProvider = new DesignerResources.LocalizationProvider(){

                        @Override
                        public LocaleStringMap getLocaleStringMap() {
                            return NamePanelBuilder.this.clonedDescription;
                        }

                        @Override
                        public TextHolder getTextHolder() {
                            return NamePanelBuilder.this.descriptionArea;
                        }
                    };
                    DesignerResources.LocalizationButton localizationButton = DesignerResources.buildLocalizationButton(NamePanelBuilder.this.getProject(), (UiContainer)panel, localizationProvider, DesignerMsg.LOCALIZE_DESCRIPTION.getString(), true);
                    Button.fixSize((Button)localizationButton);
                    LocaleStringMap description = flowNode.getDescriptionMap();
                    NamePanelBuilder.this.clonedDescription = description.clone();
                    panel.add((UiComponent)NamePanelBuilder.this.descriptionArea, (Object)"growx");
                    panel.add((UiComponent)localizationButton, (Object)"aligny top");
                    return panel;
                }
            });
            if (this.getProject().getPreferences().isTemplate()) {
                ActivityPermissionFeature activityPermissionFeature;
                boolean validFlowNode = true;
                if (flowNode.isGateway()) {
                    validFlowNode = BpmnType.COMPLEX_GATEWAY.equals((Object)flowNode.getBpmnType());
                }
                if (validFlowNode && (activityPermissionFeature = (ActivityPermissionFeature)this.flowNode.getFeature(ActivityPermissionFeature.class)) != null) {
                    this.builders.add(new DefaultRowEditorBuilder(LibMsg.PART_ROLE_INFO_PERMISSION){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            NamePanelBuilder.this.permissionCombo = UiFactory.createComboBox((UiContainer)parent, (Object[])ActivityPermissionType.values());
                            NamePanelBuilder.this.permissionCombo.setSelectedItem((Object)activityPermissionFeature.getValue());
                            NamePanelBuilder.this.permissionCombo.addItemListener(new ItemListener(){

                                public void itemStateChanged(ItemEvent e) {
                                    if (sealTypeListener != null) {
                                        final 1 listenerToRemove = this;
                                        UiUtilities.invokeLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                NamePanelBuilder.this.permissionCombo.removeItemListener(listenerToRemove);
                                                NamePanelBuilder.this.applyPermission();
                                                sealTypeListener.changed();
                                            }
                                        });
                                    }
                                }
                            });
                            return NamePanelBuilder.this.permissionCombo;
                        }
                    });
                }
            }
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.applyLabel();
            if (this.clonedDescription != null) {
                LocaleStringMap localeStringMap = this.flowNode.getDescriptionMap();
                localeStringMap.clear();
                localeStringMap.putAll(this.clonedDescription);
            }
            this.flowNode.setDefaultDescription(this.descriptionArea.getText());
            this.applyPermission();
        }

        public void validate() throws ProjectException {
            if (Str.isEmpty(this.labelField.getText())) {
                throw new ActivityHasNoNameException(this.flowNode);
            }
        }

        private void applyPermission() {
            ActivityPermissionFeature permission = (ActivityPermissionFeature)this.flowNode.getFeature(ActivityPermissionFeature.class);
            if (permission != null && this.permissionCombo != null) {
                permission.setValue((Enum)this.permissionCombo.getSelectedItem());
            }
        }

        private void applyLabel() {
            if (this.clonedLabel != null) {
                LocaleStringMap localeStringMap = this.flowNode.getLabelMap();
                localeStringMap.clear();
                localeStringMap.putAll(this.clonedLabel);
            }
            this.flowNode.setDefaultLabel(this.labelField.getText());
        }

        private Project getProject() {
            return this.flowNode.getProject();
        }
    }
}

