/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.LoopCharacteristicTypeEditor;
import oracle.bpm.designer.flowpanels.LoopCharacteristicsDataEditor;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

class LoopCharacteristicsEditor
extends AbstractCompositeEditor {
    private final AbstractFlowNodePropertiesPanel.ChangeTypeListener listener;

    private LoopCharacteristicsEditor(@NotNull FlowNode node, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
        super(ProjectModelMsg.ANNOTATIONS, node);
        this.listener = listener;
    }

    public static LoopCharacteristicsEditor create(@NotNull FlowNode node, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
        return new LoopCharacteristicsEditor(node, listener);
    }

    @Override
    public boolean shouldRender() {
        return this.isSubprocess() && super.shouldRender();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>(2);
        result.add(new LoopCharacteristicTypeEditor(this.getSubprocess(), this.listener));
        LoopCharacteristicsType type = this.getSubprocess().getLoopCharacteristicsType();
        if (type != LoopCharacteristicsType.NONE) {
            result.add(new LoopCharacteristicsDataEditor(this.getSubprocess()));
        }
        return result;
    }

    private boolean isSubprocess() {
        return ModelUtils.isSubprocess((FlowNode)this.getFlowNode()) && !ModelUtils.isEventSubprocess((FlowNode)this.getFlowNode());
    }

    private Subprocess getSubprocess() {
        return (Subprocess)this.getFlowNode().asAnyNode(Subprocess.class);
    }
}

