/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.conversation.ProjectObjectBrowser;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.ExpressionTitledPanel;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.NumericField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LoopCharacteristicsDataEditor
extends FlowNodePropertiesEditor {
    private LoopCharacteristicsDataBuilder builder;
    private static final Predicate<DataDeclaration> IS_ARRAY = new Predicate<DataDeclaration>(){

        @Override
        public boolean check(@Nullable DataDeclaration value) {
            return value != null && value.getType().isArray();
        }
    };
    private static final DefaultProjectFilter OUTPUT_ASSOCIATIONS_FILTER = new DefaultProjectFilter(){

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Subprocess) {
                Subprocess parent = (Subprocess)object;
                DataDeclarationContainer container = parent.getOutputDataAssociationSet().getArgumentsContainer();
                result = container.getDeclarations().select(IS_ARRAY);
            }
            return result;
        }
    };
    private static final DefaultProjectFilter INPUT_ASSOCIATIONS_FILTER = new DefaultProjectFilter(){

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = CollectionUtils.emptySequence();
            if (object instanceof Subprocess) {
                Subprocess parent = (Subprocess)object;
                DataDeclarationContainer container = parent.getInputDataAssociationSet().getArgumentsContainer();
                result = container.getDeclarations().select(IS_ARRAY);
            }
            return result;
        }
    };

    public LoopCharacteristicsDataEditor(@NotNull Subprocess subprocess) {
        this.builder = new LoopCharacteristicsDataBuilder(subprocess);
    }

    @Override
    public void validate() throws ProjectException {
        this.builder.validatePanel();
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private class LoopCharacteristicsDataBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private ExpressionTitledPanel cardinality;
        private ExpressionTitledPanel expression;
        private DataDeclarationsPanel inputDeclaration;
        private LoopDataPanel loopData;
        private MultiInstanceDataPanel multiData;
        private DataDeclarationsPanel outputDeclaration;
        private final Subprocess subprocess;

        public LoopCharacteristicsDataBuilder(Subprocess subprocess) {
            this.subprocess = subprocess;
            this.builders = this.createRowBuilders();
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            LoopCharacteristicsType type = this.subprocess.getLoopCharacteristicsType();
            LoopCharacteristics characteristics = this.subprocess.getLoopCharacteristics();
            if (characteristics != null) {
                if (type == LoopCharacteristicsType.MULTIINSTANCE) {
                    this.expression.panelToObject();
                    this.cardinality.panelToObject();
                    this.multiData.panelToObject();
                    this.inputDeclaration.panelToObject();
                    this.outputDeclaration.panelToObject();
                } else {
                    this.expression.panelToObject();
                    this.loopData.panelToObject();
                }
            }
        }

        public void validatePanel() throws ProjectException {
            if (!this.expression.isValidExpression()) {
                throw new ProjectException((ProjectObject)this.subprocess, DesignerMsg.INVALID_EXPRESSION);
            }
            if (this.cardinality != null && !this.cardinality.isValidExpression()) {
                throw new ProjectException((ProjectObject)this.subprocess, DesignerMsg.INVALID_CARDINALITY);
            }
        }

        private List<EditorBuilder.RowBuilder> createRowBuilders() {
            ArrayList<EditorBuilder.RowBuilder> result = new ArrayList<EditorBuilder.RowBuilder>();
            LoopCharacteristicsType type = this.subprocess.getLoopCharacteristicsType();
            LoopCharacteristics characteristics = this.subprocess.getLoopCharacteristics();
            if (characteristics != null) {
                if (type == LoopCharacteristicsType.MULTIINSTANCE) {
                    final MultiInstance multiInstance = (MultiInstance)characteristics.as(MultiInstance.class);
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.cardinality = new LoopCardialityExpressionPanel(parent, multiInstance);
                            LoopCharacteristicsDataBuilder.this.cardinality.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.cardinality;
                        }
                    });
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.expression = new CompletionConditionExpressionPanel(parent, multiInstance);
                            LoopCharacteristicsDataBuilder.this.expression.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.expression;
                        }
                    });
                    this.outputDeclaration = new DataDeclarationsPanel(DesignerMsg.LOOP_DATA_OUTPUT, (ProjectFilter)OUTPUT_ASSOCIATIONS_FILTER, multiInstance, false){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            UiComponent component = super.createEditor(parent);
                            this.objectToPanel();
                            return component;
                        }
                    };
                    result.add(this.outputDeclaration);
                    this.inputDeclaration = new DataDeclarationsPanel(DesignerMsg.LOOP_DATA_INPUT, (ProjectFilter)INPUT_ASSOCIATIONS_FILTER, multiInstance, true){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            UiComponent component = super.createEditor(parent);
                            this.objectToPanel();
                            return component;
                        }
                    };
                    result.add(this.inputDeclaration);
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.multiData = new MultiInstanceDataPanel(parent, multiInstance);
                            LoopCharacteristicsDataBuilder.this.multiData.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.multiData;
                        }
                    });
                } else {
                    final Loop loop = (Loop)characteristics.as(Loop.class);
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.expression = new LoopExpressionPanel(parent, loop);
                            LoopCharacteristicsDataBuilder.this.expression.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.expression;
                        }
                    });
                    result.add(new DefaultRowEditorBuilder(null){

                        @Override
                        public UiComponent createEditor(UiContainer parent) {
                            LoopCharacteristicsDataBuilder.this.loopData = new LoopDataPanel(parent, loop);
                            LoopCharacteristicsDataBuilder.this.loopData.objectToPanel();
                            return LoopCharacteristicsDataBuilder.this.loopData;
                        }
                    });
                }
            }
            return result;
        }

        private class MultiInstanceDataPanel
        extends Panel {
            private final MultiInstance multi;
            private CheckBox sequential;

            private MultiInstanceDataPanel(@NotNull UiContainer parent, MultiInstance multi) {
                super(parent);
                this.multi = multi;
                this.buildPanel();
            }

            public void objectToPanel() {
                this.sequential.setSelected(this.multi.isSequential());
            }

            public void panelToObject() {
                this.multi.setSequential(this.sequential.isSelected());
            }

            private void buildPanel() {
                this.setLayout((Layout)new MigLayout("gap 5, ins 5, fill"));
                this.sequential = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.IS_SEQUENTIAL);
                this.add((UiComponent)this.sequential);
            }
        }

        private class LoopExpressionPanel
        extends ExpressionTitledPanel {
            private final Loop loop;

            public LoopExpressionPanel(@NotNull UiContainer parent, Loop loop) {
                super(parent, LoopCharacteristicsDataBuilder.this.subprocess.getLoopCharacteristicsContainer(), CatalogType.Default.getBool(), DesignerMsg.LOOP_CONDITION);
                this.loop = loop;
            }

            @Override
            void objectToPanel() {
                this.setExpression(this.loop.getLoopExpression());
            }

            @Override
            void panelToObject() {
                this.loop.setLoopExpression(this.getExpression());
            }
        }

        private class LoopDataPanel
        extends Panel {
            private CheckBox beforeCheckBox;
            private final int DEFAULT_VALUE = 1;
            private final Loop loop;
            private CheckBox loopMaximumCheckBox;
            private NumericField<Integer> loopMaximumNumericField;

            private LoopDataPanel(@NotNull UiContainer parent, Loop loop) {
                super(parent);
                this.DEFAULT_VALUE = 1;
                this.loop = loop;
                this.buildPanel();
            }

            public void objectToPanel() {
                boolean hasLoopMaximum = this.loop.hasLoopMaximum();
                this.loopMaximumCheckBox.setSelected(hasLoopMaximum);
                if (hasLoopMaximum) {
                    int value = this.loop.getLoopMaximum();
                    this.loopMaximumNumericField.setValue((Number)(value < 1 ? 1 : value));
                }
                this.beforeCheckBox.setSelected(this.loop.isTestBefore());
            }

            public void panelToObject() {
                boolean hasLoopMaximum = this.loopMaximumCheckBox.isSelected();
                this.loop.setHasLoopMaximum(hasLoopMaximum);
                this.loop.setLoopMaximum(hasLoopMaximum ? (Integer)this.loopMaximumNumericField.getValue() : 1);
                this.loop.setTestBefore(this.beforeCheckBox.isSelected());
            }

            private void buildPanel() {
                this.setLayout((Layout)new MigLayout("gap 5, ins 5, fill"));
                this.loopMaximumCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.LOOP_MAXIMUM);
                this.loopMaximumCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        LoopDataPanel.this.loopMaximumNumericField.setEnabled(e.isStateSelected());
                    }
                });
                this.loopMaximumNumericField = NumericField.createIntegerNumericField((UiContainer)this, (boolean)true);
                this.loopMaximumNumericField.setMinimum((Number)1);
                this.loopMaximumNumericField.setValue((Number)1);
                this.loopMaximumNumericField.setEnabled(false);
                this.beforeCheckBox = CheckBox.create((UiContainer)this, (Msg)ProjectModelMsg.BEFORE);
                this.add((UiComponent)this.loopMaximumCheckBox);
                this.add((UiComponent)this.loopMaximumNumericField, "wrap");
                this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectModelMsg.BEFORE_AFTER));
                this.add((UiComponent)this.beforeCheckBox, "wrap");
            }
        }

        private class LoopCardialityExpressionPanel
        extends ExpressionTitledPanel {
            private final MultiInstance multi;

            public LoopCardialityExpressionPanel(@NotNull UiContainer parent, MultiInstance multi) {
                super(parent, LoopCharacteristicsDataBuilder.this.subprocess.getLoopCharacteristicsContainer(), CatalogType.Default.getInt(), DesignerMsg.LOOP_CARDINALITY);
                this.multi = multi;
            }

            @Override
            void objectToPanel() {
                this.setExpression(this.multi.getLoopCardinality());
            }

            @Override
            void panelToObject() {
                this.multi.setLoopCardinality(this.getExpression());
            }
        }

        private class DataDeclarationsPanel
        extends DefaultRowEditorBuilder {
            private ProjectObjectBrowser<DataDeclaration> browser;
            private final ProjectFilter filter;
            private final boolean input;
            private final MultiInstance multiInstance;

            public DataDeclarationsPanel(@NotNull Msg msg, @NotNull ProjectFilter filter, MultiInstance multiInstance, boolean input) {
                super(msg);
                this.filter = filter;
                this.multiInstance = multiInstance;
                this.input = input;
            }

            @Override
            public UiComponent createEditor(UiContainer parent) {
                this.browser = new ProjectObjectBrowser(parent, this.filter, (ProjectObjectContainer)LoopCharacteristicsDataBuilder.this.subprocess);
                LabelProvider.Default<DataDeclaration> labelProvider = new LabelProvider.Default<DataDeclaration>(){

                    public String getText(DataDeclaration element) {
                        return new DataDeclarationRenderer().getLabel(element);
                    }
                };
                this.browser.setLabelProvider((LabelProvider<DataDeclaration>)labelProvider);
                this.browser.addModificationListener(new ModificationListener(){

                    public void objectModified(ModificationEvent modificationEvent) {
                        DataDeclarationsPanel.this.panelToObject();
                    }
                });
                return this.browser;
            }

            public void panelToObject() {
                DataDeclaration declaration = this.browser.getValue();
                if (this.input) {
                    this.multiInstance.setLoopDataInput(declaration);
                } else {
                    this.multiInstance.setLoopDataOutput(declaration);
                }
            }

            public void objectToPanel() {
                DataDeclaration declaration = this.input ? this.multiInstance.getLoopDataInput() : this.multiInstance.getLoopDataOutput();
                this.browser.setValue(declaration);
            }
        }

        private class CompletionConditionExpressionPanel
        extends ExpressionTitledPanel {
            private final MultiInstance multi;

            public CompletionConditionExpressionPanel(@NotNull UiContainer parent, MultiInstance multi) {
                super(parent, LoopCharacteristicsDataBuilder.this.subprocess.getLoopCharacteristicsContainer(), CatalogType.Default.getBool(), DesignerMsg.COMPLETION_CONDITION, true);
                this.multi = multi;
            }

            @Override
            void objectToPanel() {
                this.setExpressionVisible(this.multi.hasCompletionCondition());
                this.setExpression(this.multi.getCompletionCondition());
            }

            @Override
            void panelToObject() {
                Expression expression = this.isExpressionVisible() ? this.getExpression() : null;
                this.multi.setCompletionCondition(expression);
            }
        }
    }
}

