/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

class LoopCharacteristicTypeEditor
extends FlowNodePropertiesEditor {
    private final CharacteristicTypeBuilder builder;

    LoopCharacteristicTypeEditor(@NotNull Subprocess subprocess, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
        this.builder = this.createEditorBuilder(subprocess, listener);
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private CharacteristicTypeBuilder createEditorBuilder(@NotNull Subprocess subprocess, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
        return new CharacteristicTypeBuilder(subprocess, listener);
    }

    private static class CharacteristicTypeRowEditor
    extends DefaultRowEditorBuilder {
        private final AbstractFlowNodePropertiesPanel.ChangeTypeListener listener;
        private final Subprocess subprocess;

        public CharacteristicTypeRowEditor(@NotNull Subprocess subprocess, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
            super(DesignerMsg.LOOP_CHARACTERISTICS);
            this.subprocess = subprocess;
            this.listener = listener;
        }

        @Override
        public UiComponent createEditor(UiContainer parent) {
            Panel panel = new Panel(parent);
            panel.setLayout((Layout)new MigLayout("ins 5, gap 5"));
            ButtonGroup group = new ButtonGroup();
            if (!this.subprocess.isTriggeredByEvent()) {
                this.addRadio(panel, (ButtonGroup<RadioButton>)group, LoopCharacteristicsType.LOOP);
            }
            this.addRadio(panel, (ButtonGroup<RadioButton>)group, LoopCharacteristicsType.MULTIINSTANCE);
            this.addRadio(panel, (ButtonGroup<RadioButton>)group, LoopCharacteristicsType.NONE);
            return panel;
        }

        private void typeChanged(@NotNull LoopCharacteristicsType type) {
            if (!this.subprocess.getLoopCharacteristicsType().equals((Object)type)) {
                this.subprocess.setLoopCharacteristicsType(type);
                this.listener.changed();
            }
        }

        private void addRadio(@NotNull Panel panel, @NotNull ButtonGroup<RadioButton> group, final @NotNull LoopCharacteristicsType type) {
            RadioButton radio = new RadioButton((UiContainer)panel, type.getLabel());
            radio.setSelected(this.subprocess.getLoopCharacteristicsType().equals((Object)type));
            radio.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent event) {
                    CharacteristicTypeRowEditor.this.typeChanged(type);
                }
            });
            group.add((AbstractButton)radio);
            panel.add((UiComponent)radio);
        }
    }

    private static class CharacteristicTypeBuilder
    extends DefaultEditorBuilder {
        private final List<EditorBuilder.RowBuilder> builders;

        public CharacteristicTypeBuilder(@NotNull Subprocess subprocess, @NotNull AbstractFlowNodePropertiesPanel.ChangeTypeListener listener) {
            CharacteristicTypeRowEditor row = new CharacteristicTypeRowEditor(subprocess, listener);
            this.builders = Collections.singletonList(row);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }
    }
}

