/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class HumanTaskTypeCombo
extends ComboBox<HumanTaskType> {
    private DefaultTheme theme;

    private HumanTaskTypeCombo(UiContainer parent, HumanTaskType defaultValue) {
        this(parent, Arrays.asList(HumanTaskType.values()), defaultValue);
    }

    private HumanTaskTypeCombo(UiContainer parent, List<HumanTaskType> values, HumanTaskType defaultValue) {
        super(parent, false, false, null, new ArrayList<HumanTaskType>(values));
        if (defaultValue != null) {
            this.setSelectedItem(defaultValue);
        }
        this.setLabelProvider((LabelProvider)new LabelProvider<HumanTaskType>(){

            public Image getIcon(HumanTaskType element) {
                FlowFigureType type = FlowFigureUtils.fromUserTask((HumanTaskType)element);
                return type != null ? HumanTaskTypeCombo.this.getTheme().getImageFor(type, ImageType.MINI_ICON) : null;
            }

            public String getText(HumanTaskType element) {
                return element.getString();
            }
        });
    }

    public static HumanTaskTypeCombo create(UiContainer parent, HumanTaskType defaultValue) {
        return new HumanTaskTypeCombo(parent, defaultValue);
    }

    public static HumanTaskTypeCombo createWithoutComplex(UiContainer parent, HumanTaskType defaultValue) {
        ArrayList<HumanTaskType> values = new ArrayList<HumanTaskType>();
        values.add(HumanTaskType.SIMPLE);
        values.add(HumanTaskType.FYI);
        values.add(HumanTaskType.MANAGEMENT);
        values.add(HumanTaskType.GROUP);
        values.add(HumanTaskType.INITIATOR);
        return new HumanTaskTypeCombo(parent, values, defaultValue);
    }

    private DefaultTheme getTheme() {
        if (this.theme == null) {
            this.theme = DesignerPreferences.getPreferences().getTheme();
        }
        return this.theme;
    }
}

