/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.project.model.processes.ActivityGenerateEvents;
import oracle.bpm.project.model.processes.activities.GenerateEventsFeature;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;

class GenerateEventsEditor
extends FlowNodePropertiesEditor {
    private GenerateEventsEditorBuilder builder;

    public GenerateEventsEditor(GenerateEventsFeature feature) {
        this.builder = new GenerateEventsEditorBuilder(feature);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class GenerateEventsEditorBuilder
    extends DefaultEditorBuilder {
        private ArrayList<EditorBuilder.RowBuilder> builders;
        private RadioButton defaultProcessEvents;
        private GenerateEventsFeature feature;
        private RadioButton generateEvents;
        private RadioButton noEvents;

        public GenerateEventsEditorBuilder(final GenerateEventsFeature feature) {
            this.feature = feature;
            this.builders = new ArrayList();
            this.builders.add(new DefaultRowEditorBuilder(null){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel radioPanel = new Panel(parent);
                    radioPanel.setLayout((Layout)new BoxLayout((UiContainer)radioPanel));
                    ButtonGroup group = new ButtonGroup();
                    GenerateEventsEditorBuilder.this.defaultProcessEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.PROCESS_DEFAULT.getMsg());
                    GenerateEventsEditorBuilder.this.noEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.DO_NOT_GENERATE_EVENTS.getMsg());
                    GenerateEventsEditorBuilder.this.generateEvents = new RadioButton((UiContainer)radioPanel, ActivityGenerateEvents.GENERATE_EVENTS.getMsg());
                    radioPanel.add((UiComponent)GenerateEventsEditorBuilder.this.defaultProcessEvents);
                    radioPanel.add((UiComponent)GenerateEventsEditorBuilder.this.generateEvents);
                    radioPanel.add((UiComponent)GenerateEventsEditorBuilder.this.noEvents);
                    group.add((AbstractButton)GenerateEventsEditorBuilder.this.defaultProcessEvents);
                    group.add((AbstractButton)GenerateEventsEditorBuilder.this.generateEvents);
                    group.add((AbstractButton)GenerateEventsEditorBuilder.this.noEvents);
                    switch ((ActivityGenerateEvents)feature.getValue()) {
                        case DO_NOT_GENERATE_EVENTS: {
                            GenerateEventsEditorBuilder.this.noEvents.setSelected(true);
                            break;
                        }
                        case GENERATE_EVENTS: {
                            GenerateEventsEditorBuilder.this.generateEvents.setSelected(true);
                            break;
                        }
                        case PROCESS_DEFAULT: {
                            GenerateEventsEditorBuilder.this.defaultProcessEvents.setSelected(true);
                        }
                    }
                    return radioPanel;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            ActivityGenerateEvents value = this.noEvents.isSelected() ? ActivityGenerateEvents.DO_NOT_GENERATE_EVENTS : (this.generateEvents.isSelected() ? ActivityGenerateEvents.GENERATE_EVENTS : ActivityGenerateEvents.PROCESS_DEFAULT);
            this.feature.setValue((Enum)value);
        }
    }
}

