/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

abstract class ExpressionTitledPanel
extends Panel {
    private ExpressionPanel expression;
    private CheckBox expressionCheckbox;

    public ExpressionTitledPanel(UiContainer parent, @NotNull DataDeclarationContainer context, @NotNull CatalogType result, @NotNull Msg title) {
        this(parent, context, result, title, false);
    }

    public ExpressionTitledPanel(UiContainer parent, @NotNull DataDeclarationContainer context, @NotNull CatalogType result, @NotNull Msg title, boolean showCheckbox) {
        super(parent, title);
        this.buildExpressionPanel(context, result, showCheckbox);
    }

    public void setExpressionVisible(boolean value) {
        if (this.expressionCheckbox != null) {
            this.expressionCheckbox.setSelected(value);
        } else {
            this.expression.setVisible(value);
        }
    }

    public boolean isExpressionVisible() {
        return this.expressionCheckbox == null || this.expressionCheckbox.isSelected();
    }

    public boolean isValidExpression() {
        return this.expression.isValid();
    }

    protected void setExpression(@NotNull Expression expression) {
        this.expression.setExpression(expression);
    }

    protected Expression getExpression() {
        return this.expression.getExpression();
    }

    abstract void objectToPanel();

    abstract void panelToObject();

    private void buildExpressionPanel(@NotNull DataDeclarationContainer context, @NotNull CatalogType result, boolean showCheckbox) {
        this.setLayout((Layout)new BorderLayout(5, 5));
        this.expression = ExpressionPanel.createWithRadioSelector((UiContainer)this, context, result);
        this.expression.makeRecyclable();
        this.add((UiComponent)this.expression, "Center");
        if (showCheckbox) {
            this.expressionCheckbox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.USE_EXPRESSION);
            this.add((UiComponent)this.expressionCheckbox, "North");
            this.expressionCheckbox.addModificationListener(new ModificationListener(){

                public void objectModified(ModificationEvent modificationEvent) {
                    ExpressionTitledPanel.this.expression.setVisible(ExpressionTitledPanel.this.expressionCheckbox.isSelected());
                }
            });
            this.expression.setVisible(false);
        }
    }
}

