/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.AnnotationsEditor;
import oracle.bpm.designer.flowpanels.EventImplementationEditor;
import oracle.bpm.designer.flowpanels.PropertiesSheet;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

class EventPropertiesPanel
extends AbstractFlowNodePropertiesPanel {
    public EventPropertiesPanel(@NotNull Event node) {
        super((FlowNode)node);
    }

    @Override
    protected PropertiesSheet createImplementationSheet(AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        PropertiesSheet result = new PropertiesSheet(ProjectMsg.IMPLEMENTATION);
        result.addCompositeEditor(EventImplementationEditor.create(this.getEvent(), changeTypeListener));
        AnnotationsEditor annotationsEditor = AnnotationsEditor.create(this.getFlowNode());
        result.addCompositeEditor(annotationsEditor.getMsg(), annotationsEditor);
        return result;
    }

    @Override
    protected String getFlowNodeHelpId() {
        Event event = this.getEvent();
        String type = event.isStart() || event.isEnd() ? (event.isStart() ? "START" : "END") : (event.isThrowEvent() ? "THROW" : "CATCH");
        return event.getEventTriggerType().name() + "_EVENT_" + type;
    }

    private Event getEvent() {
        return (Event)this.getFlowNode().asAnyNode(Event.class);
    }
}

