/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.CatalogObjectRowEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.NavigatorActions;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

class ErrorEventEditor
extends FlowNodePropertiesEditor {
    private ErrorEventEditorBuilder builder;

    public ErrorEventEditor(Event event) {
        this.builder = new ErrorEventEditorBuilder(event);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class ErrorEventEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private CheckBox cachAllExceptionsCheckBox;
        private ErrorObject errorObject;
        private Event event;

        public ErrorEventEditorBuilder(Event event) {
            this.event = event;
            this.errorObject = this.getErrorEventDefinition().getError();
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            final boolean isCatchAll = event.isCatchEvent() && this.getErrorEventDefinition().isCatchAll();
            final ProjectFilters.ErrorObjectFilter errorObjectFilter = ProjectFilters.ErrorObjectFilter.create();
            final CatalogObjectRowEditorBuilder<ErrorObject> catalogObjectEditor = new CatalogObjectRowEditorBuilder<ErrorObject>(ProjectModelMsg.EXCEPTION, event.getProject(), (ProjectFilter)errorObjectFilter, this.errorObject){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    UiComponent editor = super.createEditor(parent);
                    this.setEnabled(!isCatchAll);
                    return editor;
                }

                @Override
                protected void change(ErrorObject newValue) {
                    ErrorEventEditorBuilder.this.errorObject = newValue;
                    ErrorEventEditorBuilder.this.applyChanges();
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_EXCEPTIONS;
                }

                @Override
                protected ProjectNavigatorBuilder createProjectNavigatorBuilder() {
                    ProjectNavigatorBuilder pnb = new ProjectNavigatorBuilder((ProjectObject)this.getProject().getCatalogRoot(), this.getBrowseTitle()){

                        @Override
                        protected ToolBar buildToolBarPanel(UiContainer parent, List<BaseAction> actions, final NavigatorActions navigatorActions) {
                            ToolBar toolBar = new ToolBar(parent);
                            CheckBox checkBox = CheckBox.create((UiContainer)toolBar, (Msg)DesignerMsg.SHOW_SYSTEM_FAULTS, (boolean)errorObjectFilter.isShowSystemFault());
                            checkBox.addItemListener(new ItemListener(){

                                public void itemStateChanged(ItemEvent e) {
                                    errorObjectFilter.setShowSystemFault(e.isStateSelected());
                                    navigatorActions.refresh();
                                }
                            });
                            toolBar.add((UiComponent)checkBox);
                            return toolBar;
                        }
                    };
                    pnb.filter(this.getProjectFilter()).initialSelection((ProjectObject)this.getValue()).hideRoot();
                    return pnb;
                }
            };
            if (event.isCatchEvent()) {
                this.builders.add(new DefaultRowEditorBuilder(null){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        ErrorEventEditorBuilder.this.cachAllExceptionsCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.CATCH_ALL_BUSINESS_EXCEPTIONS);
                        ErrorEventEditorBuilder.this.cachAllExceptionsCheckBox.setSelected(isCatchAll);
                        ErrorEventEditorBuilder.this.cachAllExceptionsCheckBox.addItemListener(new ItemListener(){

                            public void itemStateChanged(ItemEvent e) {
                                boolean isCatchAll = e.isStateSelected();
                                catalogObjectEditor.setEnabled(!isCatchAll);
                            }
                        });
                        return ErrorEventEditorBuilder.this.cachAllExceptionsCheckBox;
                    }
                });
            }
            this.builders.add(catalogObjectEditor);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            ErrorEventDefinition errorEvent = this.getErrorEventDefinition();
            boolean isCatchAll = false;
            if (this.cachAllExceptionsCheckBox != null) {
                isCatchAll = this.cachAllExceptionsCheckBox.isSelected();
                errorEvent.setCatchAll(isCatchAll);
            }
            errorEvent.setError(isCatchAll ? null : this.errorObject);
        }

        private ErrorEventDefinition getErrorEventDefinition() {
            EventDefinition eventDefinition = this.getEvent().getEventDefinition();
            return (ErrorEventDefinition)eventDefinition.as(ErrorEventDefinition.class);
        }

        private Event getEvent() {
            return this.event;
        }
    }
}

