/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import oracle.bpm.designer.argumentmapping.ComplexArgumentMappingDialog;
import oracle.bpm.designer.argumentmapping.transformation.DataTransformationsDialog;
import oracle.bpm.designer.flowpanels.ChangesApplicable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class DataAssociationsPanel
extends Panel {
    private DataAssociationSet inputDataAssociationSet;
    private ArrayList<ChangesApplicable> listeners = new ArrayList();
    private DataAssociationSet outputDataAssociationSet;
    private CheckBox useAssociationsCheckbox;
    private CheckBox useXSLTCheckbox;

    public DataAssociationsPanel(@NotNull UiContainer parent, DataAssociationSet inputDataAssociationSet, DataAssociationSet outputDataAssociationSet) {
        super(parent);
        this.inputDataAssociationSet = inputDataAssociationSet;
        this.outputDataAssociationSet = outputDataAssociationSet;
        this.init();
    }

    public boolean usesXSLTransformation() {
        return this.useXSLTCheckbox.isSelected();
    }

    public boolean usesTransformations() {
        return this.useXSLTCheckbox.isSelected();
    }

    public void addChangesApplicableListener(@NotNull ChangesApplicable listener) {
        this.listeners.add(listener);
    }

    public void removeChangesApplicableListener(@NotNull ChangesApplicable listener) {
        this.listeners.remove(listener);
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 5, gap 0"));
        this.setBorder((Border)new TitledBorder(DesignerMsg.DATA_ASSOCIATIONS));
        this.useAssociationsCheckbox = new CheckBox((UiContainer)this);
        this.useAssociationsCheckbox.setMsg(DesignerMsg.USE_ASSOCIATIONS);
        Panel associationsPanel = new Panel((UiContainer)this);
        associationsPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        associationsPanel.makeRecyclable();
        final Label modeLabel = Label.create((UiContainer)associationsPanel, (Msg)DesignerMsg.TYPE);
        final ComboBox modeCombobox = UiFactory.createComboBox((UiContainer)associationsPanel);
        modeCombobox.addItem((Object)ExpressionMode.SIMPLE);
        modeCombobox.addItem((Object)ExpressionMode.XPATH);
        modeCombobox.setSelectedItem((Object)this.getDataAssociationExpressionMode());
        final Button associationsButton = Button.createIconic((UiContainer)associationsPanel, (Msg)DesignerMsg.EDIT_DATA_ASSOCIATIONS);
        associationsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAssociationsPanel.this.fireApplyChanges();
                if (DataAssociationsPanel.this.outputDataAssociationSet == null && !DataAssociationsPanel.this.hasArguments()) {
                    MessageDialog.showNotice((Msg)DesignerMsg.DATA_ASSOCIATION_NO_ARGUMENTS);
                    return;
                }
                if (!((ExpressionMode)modeCombobox.getSelectedItem()).equals(DataAssociationsPanel.this.getDataAssociationExpressionMode())) {
                    int answer;
                    if (DataAssociationsPanel.this.hasAssociations() && (answer = MessageDialog.showQuestion((Msg)DesignerMsg.DATA_ASSOCIATIONS, (Msg)DesignerMsg.CONFIRM_DATA_ASSOCIATION_SET_LANGUAGE_CHANGE, (int)6)) == 4) {
                        return;
                    }
                    DataAssociationsPanel.this.clearDataAssociations();
                }
                DataAssociationsPanel.this.setDataAssociationExpressionMode((ExpressionMode)modeCombobox.getSelectedItem());
                ComplexArgumentMappingDialog d = new ComplexArgumentMappingDialog(associationsButton.getOwnerWindow(), (ExpressionMode)modeCombobox.getSelectedItem(), DataAssociationsPanel.this.inputDataAssociationSet, DataAssociationsPanel.this.outputDataAssociationSet);
                d.setVisible(true);
            }
        });
        modeLabel.setEnabled(this.useAssociationsCheckbox.isSelected());
        modeCombobox.setEnabled(this.useAssociationsCheckbox.isSelected());
        associationsButton.setEnabled(this.useAssociationsCheckbox.isSelected());
        this.useAssociationsCheckbox.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (!DataAssociationsPanel.this.useAssociationsCheckbox.isSelected()) {
                    boolean cleanDone = DataAssociationsPanel.this.clearDataAssociationsWithConfirm();
                    DataAssociationsPanel.this.useAssociationsCheckbox.setSelected(!cleanDone);
                }
                modeLabel.setEnabled(DataAssociationsPanel.this.useAssociationsCheckbox.isSelected());
                modeCombobox.setEnabled(DataAssociationsPanel.this.useAssociationsCheckbox.isSelected());
                associationsButton.setEnabled(DataAssociationsPanel.this.useAssociationsCheckbox.isSelected());
            }
        });
        this.useAssociationsCheckbox.setSelected(this.hasAssociations());
        associationsPanel.add((UiComponent)modeLabel);
        associationsPanel.add((UiComponent)modeCombobox, (Object)"gapx 5");
        associationsPanel.add((UiComponent)associationsButton, (Object)"gapx 5");
        this.add((UiComponent)this.useAssociationsCheckbox, "gapx 5");
        this.add((UiComponent)associationsPanel, "gapx 5, wrap");
        this.useXSLTCheckbox = new CheckBox((UiContainer)this);
        this.useXSLTCheckbox.setMsg(DesignerMsg.USE_TRANSFORMATIONS);
        this.add((UiComponent)this.useXSLTCheckbox);
        Panel transformationsPanel = new Panel((UiContainer)this);
        transformationsPanel.setLayout((Layout)new MigLayout("ins 0, gap 0"));
        transformationsPanel.makeRecyclable();
        final Button transformationsButton = Button.createIconic((UiContainer)transformationsPanel, (Msg)DesignerMsg.EDIT_XSL_TRANSFORMATIONS);
        transformationsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataAssociationsPanel.this.fireApplyChanges();
                if (DataAssociationsPanel.this.outputDataAssociationSet == null && !DataAssociationsPanel.this.hasArguments()) {
                    MessageDialog.showNotice((Msg)DesignerMsg.DATA_ASSOCIATION_NO_ARGUMENTS);
                    return;
                }
                DataTransformationsDialog d = new DataTransformationsDialog(associationsButton.getOwnerWindow(), DataAssociationsPanel.this.inputDataAssociationSet, DataAssociationsPanel.this.outputDataAssociationSet);
                d.setVisible(true);
            }
        });
        transformationsButton.setEnabled(this.useXSLTCheckbox.isSelected());
        this.useXSLTCheckbox.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                if (!DataAssociationsPanel.this.useXSLTCheckbox.isSelected()) {
                    boolean cleanDone = DataAssociationsPanel.this.clearTransformations();
                    DataAssociationsPanel.this.useXSLTCheckbox.setSelected(!cleanDone);
                }
                transformationsButton.setEnabled(DataAssociationsPanel.this.useXSLTCheckbox.isSelected());
            }
        });
        this.useXSLTCheckbox.setSelected(this.hasTransformations());
        transformationsPanel.add((UiComponent)transformationsButton);
        this.add((UiComponent)this.useXSLTCheckbox, "gapx 5");
        this.add((UiComponent)transformationsPanel, "gapy 5, gapx 5, alignx right");
    }

    private void fireApplyChanges() {
        for (ChangesApplicable listener : this.listeners) {
            listener.applyChanges();
        }
    }

    private void clearDataAssociations() {
        if (this.inputDataAssociationSet != null) {
            this.inputDataAssociationSet.clearDataAssociations();
        }
        if (this.outputDataAssociationSet != null) {
            this.outputDataAssociationSet.clearDataAssociations();
        }
    }

    private void setDataAssociationExpressionMode(@NotNull ExpressionMode mode) {
        if (this.inputDataAssociationSet != null) {
            this.inputDataAssociationSet.setExpressionMode(mode);
        }
        if (this.outputDataAssociationSet != null) {
            this.outputDataAssociationSet.setExpressionMode(mode);
        }
    }

    private ExpressionMode getDataAssociationExpressionMode() {
        ExpressionMode result = ExpressionMode.SIMPLE;
        if (this.inputDataAssociationSet != null && !this.inputDataAssociationSet.getDataAssociations().isEmpty()) {
            result = this.inputDataAssociationSet.getExpressionMode();
        } else if (this.outputDataAssociationSet != null && !this.outputDataAssociationSet.getDataAssociations().isEmpty()) {
            result = this.outputDataAssociationSet.getExpressionMode();
        }
        return result;
    }

    private boolean clearDataAssociationsWithConfirm() {
        boolean result = false;
        if (this.hasAssociations()) {
            int answer = MessageDialog.showQuestion((Msg)DesignerMsg.DATA_ASSOCIATIONS, (Msg)DesignerMsg.CONFIRM_DATA_ASSOCIATIONS_UNCHECK, (int)6);
            if (answer == 2) {
                result = true;
                this.clearDataAssociations();
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean clearTransformations() {
        boolean result = false;
        if (this.hasTransformations()) {
            int answer = MessageDialog.showQuestion((Msg)DesignerMsg.XSL_TRANSFORMATIONS, (Msg)DesignerMsg.CONFIRM_XSL_TRANSFORMATIONS_UNCHECK, (int)6);
            if (answer == 2) {
                result = true;
                if (this.inputDataAssociationSet != null) {
                    this.inputDataAssociationSet.clearDataTransformations();
                }
                if (this.outputDataAssociationSet != null) {
                    this.outputDataAssociationSet.clearDataTransformations();
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean hasArguments() {
        return this.inputDataAssociationSet != null && !this.inputDataAssociationSet.getArguments().isEmpty() || this.outputDataAssociationSet != null && !this.outputDataAssociationSet.getArguments().isEmpty();
    }

    private boolean hasTransformations() {
        return this.inputDataAssociationSet != null && !this.inputDataAssociationSet.getDataTransformations().isEmpty() || this.outputDataAssociationSet != null && !this.outputDataAssociationSet.getDataTransformations().isEmpty();
    }

    private boolean hasAssociations() {
        return this.inputDataAssociationSet != null && !this.inputDataAssociationSet.getDataAssociations().isEmpty() || this.outputDataAssociationSet != null && !this.outputDataAssociationSet.getDataAssociations().isEmpty();
    }
}

