/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class ComplexGatewayEditor
extends FlowNodePropertiesEditor {
    private ComplexGatewayEditorBuilder builder;

    public ComplexGatewayEditor(ComplexGateway gateway) {
        this.builder = new ComplexGatewayEditorBuilder(gateway);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class ComplexGatewayEditorBuilder
    extends DefaultEditorBuilder {
        private List<EditorBuilder.RowBuilder> builders;
        private ComplexGateway complexGateway;
        private ExpressionPanel expressionPanel;

        public ComplexGatewayEditorBuilder(final ComplexGateway complexGateway) {
            this.complexGateway = complexGateway;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EXPRESSION){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    CatalogType resultType = CatalogType.Default.getBool();
                    ComplexGatewayEditorBuilder.this.expressionPanel = ExpressionPanel.createWithRadioSelector(parent, (DataDeclarationContainer)complexGateway, resultType);
                    ComplexGatewayEditorBuilder.this.expressionPanel.setExpression(complexGateway.getActivationCondition());
                    return ComplexGatewayEditorBuilder.this.expressionPanel;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.getComplexGateway().setActivationCondition(this.expressionPanel.getExpression());
        }

        private ComplexGateway getComplexGateway() {
            return this.complexGateway;
        }
    }
}

