/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.LineBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

abstract class CatalogObjectRowEditorBuilder<E extends CatalogObject>
extends DefaultRowEditorBuilder {
    private Button browseButton;
    private Label participantLabel;
    private Project project;
    private ProjectFilter projectFilter;
    private Button resetButton;
    private E value;

    public CatalogObjectRowEditorBuilder(Msg msg, Project project, ProjectFilter projectFilter, E value) {
        super(msg);
        this.project = project;
        this.projectFilter = projectFilter;
        this.value = value;
    }

    public Image getCatalogObjectIcon(@NotNull E Value2) {
        return null;
    }

    @Override
    public UiComponent createEditor(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new MigLayout("fillx, gapx 3, ins 0"));
        Panel participantWithBorderPanel = new Panel(parent);
        participantWithBorderPanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        participantWithBorderPanel.setBorder(LineBorder.createGrayLineBorder());
        this.participantLabel = Label.createWithNoColon((UiContainer)participantWithBorderPanel, (Msg)Msg.QUOTE(""));
        this.setValue(this.value);
        participantWithBorderPanel.add((UiComponent)this.participantLabel, (Object)"gapx 3, grow");
        this.resetButton = this.createResetButton((UiContainer)panel);
        this.browseButton = this.createBrowseButton((UiContainer)panel);
        panel.add((UiComponent)participantWithBorderPanel, (Object)"gapy 3px, grow");
        if (this.getCustomButtonsPosition() == CustomButtonsPosition.BEGIN) {
            this.addCustomButtonsToPanel(panel);
        }
        panel.add((UiComponent)this.browseButton);
        panel.add((UiComponent)this.resetButton);
        if (this.getCustomButtonsPosition() == CustomButtonsPosition.END) {
            this.addCustomButtonsToPanel(panel);
        }
        return panel;
    }

    public void setEnabled(boolean enabled) {
        this.resetButton.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public void changeValue(E newValue) {
        this.value = newValue;
        this.setValue(this.value);
        this.change(this.value);
    }

    protected abstract void change(E var1);

    protected abstract Msg getBrowseTitle();

    protected static Button createButton(UiContainer parent, Msg msg) {
        return Button.createIconic((UiContainer)parent, (Msg)msg);
    }

    protected CustomButtonsPosition getCustomButtonsPosition() {
        return CustomButtonsPosition.END;
    }

    protected Sequence<Button> createCustomButtons(UiContainer parent) {
        return CollectionUtils.emptySequence();
    }

    protected Project getProject() {
        return this.project;
    }

    protected ProjectNavigatorBuilder createProjectNavigatorBuilder() {
        return new ProjectNavigatorBuilder((ProjectObject)this.getProject().getCatalogRoot(), this.getBrowseTitle()).filter(this.getProjectFilter()).initialSelection((ProjectObject)this.getValue()).hideRoot();
    }

    protected ProjectFilter getProjectFilter() {
        return this.projectFilter;
    }

    protected E getValue() {
        return this.value;
    }

    private void addCustomButtonsToPanel(@NotNull Panel panel) {
        Sequence<Button> buttons = this.createCustomButtons((UiContainer)panel);
        for (Button btn : buttons) {
            panel.add((UiComponent)btn);
        }
    }

    private Button createResetButton(UiContainer parent) {
        Button result = CatalogObjectRowEditorBuilder.createButton(parent, UIMsg.CLEAR);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CatalogObjectRowEditorBuilder.this.changeValue(null);
            }
        });
        return result;
    }

    private Button createBrowseButton(UiContainer parent) {
        Button result = Button.createBrowse((UiContainer)parent);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectNavigatorBuilder projectNavigatorBuilder = CatalogObjectRowEditorBuilder.this.createProjectNavigatorBuilder();
                CatalogObject object = projectNavigatorBuilder.selectSingle(CatalogObject.class);
                if (object != null) {
                    CatalogObjectRowEditorBuilder.this.changeValue(object);
                }
            }
        });
        return result;
    }

    private void setValue(E value) {
        Msg text = value != null ? Msg.QUOTE(value.getName()) : null;
        this.participantLabel.setText(text);
        Image icon = value != null ? this.getCatalogObjectIcon(value) : null;
        this.participantLabel.setIcon(icon);
    }

    protected static enum CustomButtonsPosition {
        BEGIN,
        END,
        NONE;

    }
}

