/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.ResetButton;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.AbstractLabelProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

class CallActivityEditor
extends FlowNodePropertiesEditor {
    private CallActivityEditorBuilder builder;

    public CallActivityEditor(CallActivity callActivity) {
        this.builder = new CallActivityEditorBuilder(callActivity);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class CallActivityEditorBuilder
    extends DefaultEditorBuilder {
        private CallActivity callActivity;
        private ComboBox<Process> processesCombo;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public CallActivityEditorBuilder(final CallActivity callActivity) {
            this.callActivity = callActivity;
            this.rowBuilders.add(new DefaultRowEditorBuilder(DesignerMsg.PROCESS){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    Panel panel = new Panel(parent);
                    panel.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
                    ResetButton resetButton = new ResetButton((UiContainer)panel){

                        @Override
                        protected void reset() {
                            CallActivityEditorBuilder.this.processesCombo.setSelectedIndex(-1);
                        }
                    };
                    CallActivityEditorBuilder.this.processesCombo = UiFactory.createComboBox((UiContainer)panel, (Collection)CallActivityEditorBuilder.this.getProcesses());
                    CallActivityEditorBuilder.this.processesCombo.setLabelProvider((LabelProvider)new AbstractLabelProvider<Process>(){

                        public String getText(Process element) {
                            return element.getDefaultLabel();
                        }
                    });
                    CallActivityEditorBuilder.this.processesCombo.setSelectedItem((Object)callActivity.getCalledElement());
                    panel.add((UiComponent)CallActivityEditorBuilder.this.processesCombo, (Object)"growx");
                    panel.add((UiComponent)resetButton, (Object)"wrap");
                    return panel;
                }
            });
        }

        public void applyChanges() {
            Process process = (Process)this.processesCombo.getSelectedItem();
            this.callActivity.setCalledElement(process);
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        private Collection<Process> getProcesses() {
            ArrayList<Process> result = new ArrayList<Process>();
            Process current = this.callActivity.getProcess();
            Collection processes = this.callActivity.getProject().getProcesses();
            for (Process process : processes) {
                if (process.equals(current) || !process.isCallableSubprocess() || ModelUtils.getCalledProcesses((Process)process).contains(current)) continue;
                result.add(process);
            }
            return result;
        }
    }
}

