/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BusinessRuleData;
import oracle.bpm.designer.BusinessRuleService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.OperationRowEditorBuilder;
import oracle.bpm.designer.flowpanels.SoaObjectRowEditorBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogArgument;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiWindow;

class BusinessRuleTaskEditor
extends FlowNodePropertiesEditor {
    private BusinessRuleTaskImplementationEditorBuilder builder;

    public BusinessRuleTaskEditor(BusinessRuleTask businessRuleTask) {
        this.builder = new BusinessRuleTaskImplementationEditorBuilder(businessRuleTask);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class BusinessRuleTaskImplementationEditorBuilder
    extends DefaultEditorBuilder {
        private BusinessRule businessRule;
        private BusinessRuleTask businessRuleTask;
        private CatalogMember operation;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public BusinessRuleTaskImplementationEditorBuilder(final BusinessRuleTask businessRuleTask) {
            this.businessRuleTask = businessRuleTask;
            this.businessRule = businessRuleTask.getBusinessRule();
            this.operation = businessRuleTask.getFunction();
            final OperationRowEditorBuilder operationRowEditorBuilder = new OperationRowEditorBuilder(ProjectMsg.DECISION_FUNCTION, (CatalogObject)this.businessRule, this.operation){

                @Override
                protected void change(CatalogMember newValue) {
                    BusinessRuleTaskImplementationEditorBuilder.this.operation = newValue;
                    BusinessRuleTaskImplementationEditorBuilder.this.applyChanges();
                }
            };
            StudioWorkbench workbech = AbstractStudioWorkbench.getInstance();
            final BusinessRuleService service = workbech.getBusinessRuleService();
            SoaObjectRowEditorBuilder<BusinessRule> catalogObjectRowEditorBuilder = new SoaObjectRowEditorBuilder<BusinessRule>(ProjectMsg.BUSINESS_RULE, businessRuleTask.getProject(), ProjectFilters.BUSINESS_RULES, this.businessRule){

                @Override
                protected void change(BusinessRule newValue) {
                    BusinessRuleTaskImplementationEditorBuilder.this.businessRule = newValue;
                    operationRowEditorBuilder.setParticipant((CatalogObject)newValue);
                    BusinessRuleTaskImplementationEditorBuilder.this.applyChanges();
                }

                @Override
                protected Msg getBrowseTitle() {
                    return DesignerMsg.BROWSE_BUSINESS_RULES;
                }

                @Override
                protected void addAction(UiWindow parent) {
                    URL url;
                    BusinessRule newBusinessRule;
                    BusinessRuleData businessRuleData = service.createBusinessRule(parent, (FlowNode)businessRuleTask);
                    if (businessRuleData != null && (newBusinessRule = this.findCatalogObjectFromUrl(url = businessRuleData.getUrl(), BusinessRule.class)) != null) {
                        this.changeValue(newBusinessRule);
                        CatalogMember operation = businessRuleTask.getFunction();
                        if (operation != null) {
                            Sequence arguments = operation.getArguments();
                            Sequence fixInputParameters = BusinessRuleTaskImplementationEditorBuilder.fixInputParameters(arguments, businessRuleData.getInputParameters());
                            Sequence fixOutputParameters = BusinessRuleTaskImplementationEditorBuilder.fixOutputParameters(arguments, businessRuleData.getOutputParameters());
                            2.changeInputDataAssociation(businessRuleTask.getInputDataAssociationSet(), fixInputParameters);
                            2.changeOutputDataAssociation(businessRuleTask.getOutputDataAssociationSet(), fixOutputParameters);
                        }
                    }
                }
            };
            this.rowBuilders.add(catalogObjectRowEditorBuilder);
            this.rowBuilders.add(operationRowEditorBuilder);
        }

        public void applyChanges() {
            try {
                this.businessRuleTask.setBusinessRule(this.businessRule);
                CatalogMember newOperation = this.businessRule == null ? null : this.operation;
                this.businessRuleTask.setFunction(newOperation);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        private static Sequence<Tuple<String, String>> fixInputParameters(Sequence<CatalogArgument> arguments, Sequence<Tuple<String, String>> inputParameters) {
            ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
            List<String> inArguments = BusinessRuleTaskImplementationEditorBuilder.getArguments(arguments, true);
            int i = 0;
            for (Tuple<String, String> tuple : inputParameters) {
                String second = i < inArguments.size() ? inArguments.get(i) : tuple.getSecond();
                Tuple<String, String> fixedTuple = Tuple.create(tuple.getFirst(), second);
                result.add(fixedTuple);
            }
            return CollectionUtils.asSequence(result);
        }

        private static Sequence<Tuple<String, String>> fixOutputParameters(Sequence<CatalogArgument> arguments, Sequence<Tuple<String, String>> outputParameters) {
            ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
            List<String> outArguments = BusinessRuleTaskImplementationEditorBuilder.getArguments(arguments, false);
            int i = 0;
            for (Tuple<String, String> tuple : outputParameters) {
                String first = i < outArguments.size() ? outArguments.get(i) : tuple.getFirst();
                Tuple<String, String> fixedTuple = Tuple.create(first, tuple.getSecond());
                result.add(fixedTuple);
            }
            return CollectionUtils.asSequence(result);
        }

        private static List<String> getArguments(Sequence<CatalogArgument> arguments, boolean in) {
            ArrayList<String> result = new ArrayList<String>();
            for (CatalogArgument argument : arguments) {
                if (in != argument.isIn()) continue;
                result.add(argument.getName());
            }
            return result;
        }
    }
}

