/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;

class BoundaryEventEditor
extends FlowNodePropertiesEditor {
    private BoundaryEventEditorBuilder builder;

    public BoundaryEventEditor(BoundaryEvent event) {
        this.builder = new BoundaryEventEditorBuilder(event);
    }

    @Override
    public void applyChanges() {
        this.builder.applyChanges();
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    private static class BoundaryEventEditorBuilder
    extends DefaultEditorBuilder {
        private BoundaryEvent boundaryEvent;
        private List<EditorBuilder.RowBuilder> builders;
        private CheckBox interrupCheckBox;

        public BoundaryEventEditorBuilder(final BoundaryEvent event) {
            this.boundaryEvent = event;
            this.builders = new ArrayList<EditorBuilder.RowBuilder>();
            this.builders.add(new DefaultRowEditorBuilder(DesignerMsg.EMPTY_MSG("")){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    BoundaryEventEditorBuilder.this.interrupCheckBox = CheckBox.create((UiContainer)parent, (Msg)ProjectModelMsg.ALLOWS_INTERRUPTIONS);
                    BoundaryEventEditorBuilder.this.interrupCheckBox.setSelected(event.cancelActivity());
                    return BoundaryEventEditorBuilder.this.interrupCheckBox;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.builders;
        }

        public void applyChanges() {
            this.getBoundaryEvent().setCancelActivity(this.interrupCheckBox.isSelected());
        }

        private BoundaryEvent getBoundaryEvent() {
            return this.boundaryEvent;
        }
    }
}

