/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.flowpanels.ChangesApplicable;
import oracle.bpm.designer.flowpanels.DataAssociationsPanel;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class AssociationTaskEditor
extends FlowNodePropertiesEditor {
    private AssociationEditorBuilder builder;
    private FlowElement flowElement;

    public AssociationTaskEditor(@NotNull FlowElement flowElement) {
        this(flowElement, CollectionUtils.emptySequence());
    }

    public AssociationTaskEditor(@NotNull FlowElement flowElement, @NotNull Sequence<ChangesApplicable> changeDependencies) {
        this.flowElement = flowElement;
        ArrayList<ChangesApplicable> fixedDependecies = new ArrayList<ChangesApplicable>();
        for (ChangesApplicable dependence : changeDependencies) {
            fixedDependecies.add(dependence);
        }
        fixedDependecies.add(this);
        this.builder = new AssociationEditorBuilder(this.getInputDataAssociationSet(), this.getOutputDataAssociationSet(), CollectionUtils.asSequence(fixedDependecies));
    }

    @Override
    public EditorBuilder getEditorBuilder() {
        return this.builder;
    }

    @Override
    public void applyChanges() {
        if (UserTask.class.isAssignableFrom(this.flowElement.getRawClass())) {
            UserTask userTask = (UserTask)this.flowElement;
            userTask.setUsesTransformations(this.builder.usesTransformations());
        }
    }

    private DataAssociationSet getInputDataAssociationSet() {
        return this.flowElement.getFeature(IncomingDataAssociationFeature.class) != null ? ((IncomingDataAssociationFeature)this.flowElement.getFeature(IncomingDataAssociationFeature.class)).getDataAssociationSet() : null;
    }

    private DataAssociationSet getOutputDataAssociationSet() {
        return this.flowElement.getFeature(OutgoingDataAssociationFeature.class) != null ? ((OutgoingDataAssociationFeature)this.flowElement.getFeature(OutgoingDataAssociationFeature.class)).getDataAssociationSet() : null;
    }

    private static class AssociationEditorBuilder
    extends DefaultEditorBuilder {
        private DataAssociationsPanel dataAssociationsPanel;
        private List<EditorBuilder.RowBuilder> rowBuilders = new ArrayList<EditorBuilder.RowBuilder>();

        public AssociationEditorBuilder(final DataAssociationSet inputSet, final DataAssociationSet outputSet, final @NotNull Sequence<ChangesApplicable> changeDependencies) {
            this.rowBuilders.add(new DefaultRowEditorBuilder(null){

                @Override
                public UiComponent createEditor(UiContainer parent) {
                    AssociationEditorBuilder.this.dataAssociationsPanel = new DataAssociationsPanel(parent, inputSet, outputSet);
                    for (ChangesApplicable listener : changeDependencies) {
                        AssociationEditorBuilder.this.dataAssociationsPanel.addChangesApplicableListener(listener);
                    }
                    return AssociationEditorBuilder.this.dataAssociationsPanel;
                }
            });
        }

        @Override
        public List<EditorBuilder.RowBuilder> getBuilders() {
            return this.rowBuilders;
        }

        public boolean usesTransformations() {
            return this.dataAssociationsPanel != null && this.dataAssociationsPanel.usesXSLTransformation();
        }
    }
}

