/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.argumentsdefinition.ArgumentsDefinitionPanel;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.AssociationTaskEditor;
import oracle.bpm.designer.flowpanels.DefaultEditorBuilder;
import oracle.bpm.designer.flowpanels.DefaultRowEditorBuilder;
import oracle.bpm.designer.flowpanels.EditorBuilder;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class ArgumentsDefinitionEditor
extends AbstractCompositeEditor {
    private boolean showDataAssociationsEditor;

    private ArgumentsDefinitionEditor(@NotNull FlowNode node, boolean showDataAssociationsEditor) {
        super(DesignerMsg.ARGUMENTS_DEFINITION, node);
        this.showDataAssociationsEditor = showDataAssociationsEditor;
    }

    public static ArgumentsDefinitionEditor create(@NotNull FlowNode node) {
        return ArgumentsDefinitionEditor.create(node, false);
    }

    public static ArgumentsDefinitionEditor create(@NotNull FlowNode node, boolean showDataAssociationsEditor) {
        return new ArgumentsDefinitionEditor(node, showDataAssociationsEditor);
    }

    @Override
    public boolean shouldRender() {
        return this.isSubprocess() && super.shouldRender();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        ArrayList<FlowNodePropertiesEditor> result = new ArrayList<FlowNodePropertiesEditor>();
        ArgumentsDefinitionPropertyEditor argumentsEditor = new ArgumentsDefinitionPropertyEditor(this.getFlowNode());
        result.add(argumentsEditor);
        if (this.showDataAssociationsEditor) {
            result.add(new AssociationTaskEditor((FlowElement)this.getFlowNode(), CollectionUtils.singletonSequence(argumentsEditor)));
        }
        return result;
    }

    private boolean isSubprocess() {
        return this.getSubprocess() != null && !this.getSubprocess().isTriggeredByEvent();
    }

    private Subprocess getSubprocess() {
        return (Subprocess)this.getFlowNode().asAnyNode(Subprocess.class);
    }

    private static class ArgumentsDefinitionPropertyEditor
    extends FlowNodePropertiesEditor {
        private ArgumentsDefinitionEditorBuilder builder;

        public ArgumentsDefinitionPropertyEditor(@NotNull FlowNode flowNode) {
            this.builder = new ArgumentsDefinitionEditorBuilder((Subprocess)flowNode.asAnyNode(Subprocess.class));
        }

        @Override
        public void applyChanges() {
            this.builder.applyChanges();
        }

        @Override
        public EditorBuilder getEditorBuilder() {
            return this.builder;
        }

        private static class ArgumentsDefinitionEditorBuilder
        extends DefaultEditorBuilder {
            private ArgumentsDefinitionPanel definitions;
            private DataDeclarationContainer input;
            private DataDeclarationContainer output;

            public ArgumentsDefinitionEditorBuilder(@NotNull Subprocess subprocess) {
                this.input = subprocess.getInputArgumentsContainer();
                this.output = subprocess.getOutputArgumentsContainer();
            }

            @Override
            public List<EditorBuilder.RowBuilder> getBuilders() {
                DefaultRowEditorBuilder argumentsBuilder = new DefaultRowEditorBuilder(null){

                    @Override
                    public UiComponent createEditor(UiContainer parent) {
                        ArgumentsDefinitionEditorBuilder.this.definitions = new ArgumentsDefinitionPanel(parent, ArgumentsDefinitionEditorBuilder.this.input, ArgumentsDefinitionEditorBuilder.this.output);
                        ArgumentsDefinitionEditorBuilder.this.definitions.setPreferredSize(Dimension.valueOf(50, 150));
                        return ArgumentsDefinitionEditorBuilder.this.definitions;
                    }
                };
                return Collections.singletonList(argumentsBuilder);
            }

            public void applyChanges() {
            }
        }
    }
}

