/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.Collections;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.flowpanels.AbstractCompositeEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.UserTaskAdvancedEditor;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.ui.msg.UIMsg;

class AdvancedEditor
extends AbstractCompositeEditor {
    private AdvancedEditor(FlowNode node) {
        super(UIMsg.ADVANCED, node);
    }

    public static AdvancedEditor create(FlowNode node) {
        return new AdvancedEditor(node);
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && !AbstractStudioWorkbench.getInstance().isBusinessAnalyst();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        List<FlowNodePropertiesEditor> result = Collections.emptyList();
        FlowNode node = this.getFlowNode();
        if (node.isActivity() && ((Activity)node).isUserTask()) {
            UserTaskAdvancedEditor editor = new UserTaskAdvancedEditor((UserTask)node);
            result = Collections.singletonList(editor);
        }
        return result;
    }
}

