/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.designer.flowpanels.ActivityChageTypeEditor;
import oracle.bpm.designer.flowpanels.AssociationTaskEditor;
import oracle.bpm.designer.flowpanels.BusinessRuleTaskEditor;
import oracle.bpm.designer.flowpanels.CallActivityEditor;
import oracle.bpm.designer.flowpanels.ConversationEditor;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesEditor;
import oracle.bpm.designer.flowpanels.ImplementationEditor;
import oracle.bpm.designer.flowpanels.ReceiveTaskSpecificEditor;
import oracle.bpm.designer.flowpanels.ServiceTaskEditor;
import oracle.bpm.designer.flowpanels.UserTaskEditor;
import oracle.bpm.project.model.features.ActivityPermissionFeature;
import oracle.bpm.project.model.features.ReceiveTaskFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.ActivityPermissionType;
import oracle.bpm.project.model.util.ModelUtils;

class ActivityImplementationEditor
extends ImplementationEditor {
    private ActivityImplementationEditor(Activity activity, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        super((FlowNode)activity, changeTypeListener);
    }

    public static ActivityImplementationEditor create(Activity activity, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new ActivityImplementationEditor(activity, changeTypeListener);
    }

    @Override
    public boolean shouldRender() {
        return !ModelUtils.isSubprocess((FlowNode)this.getFlowNode()) && super.shouldRender();
    }

    public Activity getFlowNode() {
        return (Activity)super.getFlowNode();
    }

    @Override
    protected List<FlowNodePropertiesEditor> buildEditors() {
        boolean shouldRenderImpl;
        Activity activity = this.getFlowNode();
        ArrayList<FlowNodePropertiesEditor> editors = new ArrayList<FlowNodePropertiesEditor>();
        editors.add(ActivityChageTypeEditor.create((FlowNode)activity, this.getChangeTypeListener()));
        ActivityPermissionFeature feature = (ActivityPermissionFeature)activity.getFeature(ActivityPermissionFeature.class);
        ActivityPermissionType type = (ActivityPermissionType)feature.getValue();
        boolean bl = shouldRenderImpl = type != ActivityPermissionType.SHOULD_DEFINE;
        if (activity.isScriptTask()) {
            if (shouldRenderImpl) {
                editors.add(new AssociationTaskEditor((FlowElement)activity));
            }
        } else if (activity.isUserTask()) {
            if (shouldRenderImpl) {
                UserTask userTask = (UserTask)activity.asAnyNode(UserTask.class);
                editors.add(new UserTaskEditor(userTask));
            }
        } else if (activity.isServiceTask()) {
            if (shouldRenderImpl) {
                ServiceTask serviceTask = (ServiceTask)activity.asAnyNode(ServiceTask.class);
                ServiceTaskEditor serviceTaskEditor = new ServiceTaskEditor(serviceTask);
                editors.add(serviceTaskEditor);
                editors.add(new AssociationTaskEditor((FlowElement)serviceTask, CollectionUtils.singletonSequence(serviceTaskEditor)));
            }
        } else if (activity.isBusinessRuleTask()) {
            if (shouldRenderImpl) {
                BusinessRuleTask businessRuleTask = (BusinessRuleTask)activity.asAnyNode(BusinessRuleTask.class);
                editors.add(new BusinessRuleTaskEditor(businessRuleTask));
                editors.add(new AssociationTaskEditor((FlowElement)activity));
            }
        } else if (activity.isSendTask()) {
            ConversationEditor conversationEditor = new ConversationEditor((ConversationEnabled)activity);
            editors.add(conversationEditor);
            if (shouldRenderImpl) {
                AssociationTaskEditor associationEditor = new AssociationTaskEditor((FlowElement)activity, CollectionUtils.singletonSequence(conversationEditor));
                editors.add(associationEditor);
            }
        } else if (activity.isReceiveTask()) {
            if (shouldRenderImpl) {
                ReceiveTaskFeature receiveTaskFeature = (ReceiveTaskFeature)activity.getFeature(ReceiveTaskFeature.class);
                editors.add(new ReceiveTaskSpecificEditor(receiveTaskFeature));
            }
            ConversationEditor conversationEditor = new ConversationEditor((ConversationEnabled)activity);
            editors.add(conversationEditor);
            if (shouldRenderImpl) {
                AssociationTaskEditor associationEditor = new AssociationTaskEditor((FlowElement)activity, CollectionUtils.singletonSequence(conversationEditor));
                editors.add(associationEditor);
            }
        } else if (activity.isCallActivity()) {
            CallActivity callActivity = (CallActivity)activity.asAnyNode(CallActivity.class);
            CallActivityEditor callActivityEditor = new CallActivityEditor(callActivity);
            editors.add(callActivityEditor);
            AssociationTaskEditor associationsEditor = new AssociationTaskEditor((FlowElement)activity, CollectionUtils.singletonSequence(callActivityEditor));
            editors.add(associationsEditor);
        }
        return editors;
    }
}

