/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.flowpanels;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.flowpanels.AbstractChangeTypeEditor;
import oracle.bpm.designer.flowpanels.AbstractFlowNodePropertiesPanel;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;

class ActivityChageTypeEditor
extends AbstractChangeTypeEditor {
    private ActivityChageTypeEditor(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        super(flowNode, changeTypeListener);
    }

    public static ActivityChageTypeEditor create(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new ActivityChageTypeEditor(flowNode, changeTypeListener);
    }

    @Override
    protected AbstractChangeTypeEditor.ChangeTypeBuilder createBuilder(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
        return new ActivityChangeTypeBuilder(flowNode, changeTypeListener);
    }

    private static class ActivityChangeTypeBuilder
    extends AbstractChangeTypeEditor.ChangeTypeBuilder<BpmnType> {
        ActivityChangeTypeBuilder(FlowNode flowNode, AbstractFlowNodePropertiesPanel.ChangeTypeListener changeTypeListener) {
            super(flowNode, changeTypeListener);
        }

        @Override
        protected List<BpmnType> getValues() {
            ArrayList<BpmnType> values = new ArrayList<BpmnType>();
            for (BpmnType future : ChangeActivityTypeCommand.getAllPosibleChanges()) {
                values.add(future);
            }
            return values;
        }

        @Override
        protected BpmnType getValue() {
            return this.getFlowNode().getBpmnType();
        }

        @Override
        protected void applyChange(BpmnType newValue) {
            ChangeActivityTypeCommand.change((Activity)((Activity)this.getFlowNode()), (BpmnType)newValue);
        }

        @Override
        protected FlowFigureType getFlowFigureType(BpmnType value) {
            return FlowFigureUtils.fromType((BpmnType)value);
        }
    }
}

