/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.external;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Insets;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

class ResourceTitlePanel
extends Panel {
    private LabelMultiline descriptionLabel;
    private Label titleLabel;

    public ResourceTitlePanel(UiContainer parent, Image icon) {
        super(parent);
        this.setLayout((Layout)new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        Panel imagePanel = new Panel((UiContainer)this);
        imagePanel.setLayout((Layout)new BorderLayout());
        imagePanel.setOpaque(true);
        imagePanel.setBackground(this.getBackground());
        imagePanel.setBorder(BorderFactory.createEmptyBorder((int)2, (int)10, (int)2, (int)10));
        Label iconLabel = Label.create((UiContainer)imagePanel, (Image)icon);
        iconLabel.setOpaque(false);
        imagePanel.add((UiComponent)iconLabel, (Object)"Center");
        Panel centerPanel = new Panel((UiContainer)this);
        centerPanel.setLayout((Layout)new GridBagLayout());
        centerPanel.setOpaque(true);
        centerPanel.setBackground(this.getBackground());
        this.titleLabel = this.createLabel((UiContainer)centerPanel);
        this.descriptionLabel = new LabelMultiline((UiContainer)centerPanel);
        centerPanel.add((UiComponent)this.titleLabel, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 2, 2, 2), 0, 0));
        centerPanel.add(Box.createHorizontalStrut((UiContainer)centerPanel, (int)25), (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        centerPanel.add((UiComponent)this.descriptionLabel, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        Panel westPanel = new Panel((UiContainer)this);
        imagePanel.setOpaque(true);
        westPanel.setBackground(this.getBackground());
        westPanel.setBorder(BorderFactory.createEmptyBorder((int)2, (int)10, (int)2, (int)10));
        this.add((UiComponent)imagePanel, "East");
        this.add((UiComponent)centerPanel, "Center");
        this.add((UiComponent)westPanel, "West");
    }

    public void setDescription(Msg msg) {
        this.descriptionLabel.setMsg(msg);
    }

    public void setDescription(String msg) {
        this.descriptionLabel.setMsg(UIMsg.TO_MSG((String)msg));
    }

    public void setTitle(Msg msg) {
        this.titleLabel.setMsg(msg);
    }

    public void setTitle(String msg) {
        this.titleLabel.setText(msg);
    }

    private Label createLabel(UiContainer parent) {
        Label label = Label.create((UiContainer)parent);
        Font labelFont = label.getFont();
        if (!labelFont.isBold()) {
            label.setFont(labelFont.bold());
        }
        label.setOpaque(false);
        return label;
    }
}

