/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import oracle.bpm.io.StreamUtils;

abstract class AbstractFilter
extends OutputStream {
    protected boolean[] specialsTable;
    protected char[] translationTable = latin1TranslationTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    public AbstractFilter() {
        this.specialsTable = noSpecialsTable;
    }

    public void readFromReader(Reader reader) throws IOException {
        int i;
        char[] ac = new char[2048];
        while ((i = reader.read(ac)) >= 0) {
            for (int j = 0; j < i; ++j) {
                this.write(ac[j]);
            }
        }
    }

    public void readFromStream(InputStream inputstream) throws IOException {
        StreamUtils.copy(inputstream, this);
    }

    @Override
    public void write(int i) throws IOException {
        if (i < 0) {
            i += 256;
        }
        if (this.specialsTable[i]) {
            this.writeSpecial(i);
        } else {
            char c = this.translationTable[i];
            if (c != '\u0000') {
                this.write(c);
            }
        }
    }

    public void write(String s) throws IOException {
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void write(byte[] abyte0, int i, int j) throws IOException {
        StringBuffer stringbuffer = null;
        while (j > 0) {
            short word0 = abyte0[i];
            if (word0 < 0) {
                word0 = (short)(word0 + 256);
            }
            if (this.specialsTable[word0]) {
                if (stringbuffer != null) {
                    this.write(stringbuffer.toString());
                    stringbuffer = null;
                }
                this.writeSpecial(word0);
            } else {
                char c = this.translationTable[word0];
                if (c != '\u0000') {
                    if (stringbuffer == null) {
                        stringbuffer = new StringBuffer();
                    }
                    stringbuffer.append(c);
                }
            }
            --j;
            ++i;
        }
        if (stringbuffer != null) {
            this.write(stringbuffer.toString());
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        noSpecialsTable = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            AbstractFilter.noSpecialsTable[i] = false;
        }
        allSpecialsTable = new boolean[256];
        for (int j = 0; j < 256; ++j) {
            AbstractFilter.allSpecialsTable[j] = true;
        }
        latin1TranslationTable = new char[256];
        for (int k = 0; k < 256; ++k) {
            AbstractFilter.latin1TranslationTable[k] = (char)k;
        }
    }
}

