/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.EmptyRoleLabelValidator;
import oracle.bpm.designer.validator.organization.RoleExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class RoleDialog
extends AbstractOrganizationDialog<Role> {
    public RoleDialog(UiWindow parent, Organization organization) {
        super(parent, organization);
        this.setTitle(DesignerMsg.ROLE.getString());
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.ROLE;
    }

    @Override
    protected Role addNewProjectObject(Role role) throws ProjectException {
        this.getOrganization().addChild((ProjectObject)role);
        return role;
    }

    @Override
    protected Role createNewProjectObject(String roleName) throws ProjectException {
        String id = ModelUtils.generateRoleId((Organization)this.getOrganization(), (String)roleName);
        return this.getOrganization().createRole(id, roleName);
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new RoleExistenceValidator(this.getProject()));
        compositeValidator.addValidator(new EmptyRoleLabelValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        for (Role role : this.getOrganization().getRoles()) {
            if (!role.getName().equals(suggestedName)) continue;
            return true;
        }
        return false;
    }
}

