/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.ParticipantExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class ParticipantDialog
extends AbstractOrganizationDialog<Participant> {
    public ParticipantDialog(UiWindow parent, Organization organization) {
        super(parent, organization);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.PARTICIPANT;
    }

    @Override
    protected Participant createNewProjectObject(String participantId) throws ProjectException {
        return this.getOrganization().createParticipant(participantId);
    }

    @Override
    protected Participant addNewProjectObject(Participant participant) throws ProjectException {
        this.getOrganization().addOrganizationalObject((ProjectObject)participant);
        return participant;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new ParticipantExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected Msg getLabelMsg() {
        return DesignerMsg.PARTICIPANT_ID;
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        return this.getOrganization().findParticipant(suggestedName) != null;
    }
}

