/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.OrganizationalUnitExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrganizationalUnitDialog
extends AbstractOrganizationDialog<OrganizationalUnit> {
    private OrganizationalUnit parentOu;

    public OrganizationalUnitDialog(UiWindow parent, @NotNull Organization organization, @Nullable OrganizationalUnit parentOu) {
        super(parent, organization);
        this.parentOu = parentOu;
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.ORGANIZATIONAL_UNIT;
    }

    @Override
    protected String getSuggestedPrefix() {
        return DesignerMsg.ORGANIZATIONAL_UNIT.toString().replaceAll(" ", "");
    }

    @Override
    protected OrganizationalUnit createNewProjectObject(String name) throws ProjectException {
        String ouId = ModelUtils.generateOrganizationalUnitId((Organization)this.getOrganization());
        OrganizationalUnit organizationalUnit = this.getOrganization().createOrganizationalUnit(ouId, this.parentOu);
        organizationalUnit.setName(name);
        return organizationalUnit;
    }

    @Override
    protected OrganizationalUnit addNewProjectObject(OrganizationalUnit ou) throws ProjectException {
        this.getOrganization().addOrganizationalObject((ProjectObject)ou);
        return ou;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new OrganizationalUnitExistenceValidator(this.getOrganization().getOrganizationalChart(), this.parentOu));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, "", 0, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        Sequence ous = this.getOrganization().getOrganizationalChart().getDescendants(OrganizationalUnit.class);
        for (OrganizationalUnit ou : ous) {
            if (!suggestedName.equals(ou.getName())) continue;
            return true;
        }
        return false;
    }
}

