/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.HolidayRuleExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class HolidayRuleDialog
extends AbstractOrganizationDialog<HolidayRule> {
    public HolidayRuleDialog(UiWindow parent, Organization organization) {
        super(parent, organization);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.HOLIDAY_RULE;
    }

    @Override
    protected String getSuggestedPrefix() {
        return DesignerMsg.HOLIDAY_RULE.toString().replaceAll(" ", "");
    }

    @Override
    protected HolidayRule createNewProjectObject(String name) throws ProjectException {
        String holidayRuleId = ModelUtils.generateCalendarRuleId((Organization)this.getOrganization());
        HolidayRule holidayRule = this.getOrganization().createHolidayRule(holidayRuleId);
        holidayRule.setName(name);
        return holidayRule;
    }

    @Override
    protected HolidayRule addNewProjectObject(HolidayRule holidayRule) throws ProjectException {
        this.getOrganization().addOrganizationalObject((ProjectObject)holidayRule);
        return holidayRule;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new HolidayRuleExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        Sequence holidays = this.getOrganization().getHolidayRules();
        for (HolidayRule holidayRule : holidays) {
            if (!suggestedName.equals(holidayRule.getName())) continue;
            return true;
        }
        return false;
    }
}

