/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.GroupExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class GroupDialog
extends AbstractOrganizationDialog<Group> {
    public GroupDialog(UiWindow parent, Organization organization) {
        super(parent, organization);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.GROUP;
    }

    @Override
    protected Group createNewProjectObject(String groupId) throws ProjectException {
        return this.getOrganization().createGroup(groupId);
    }

    @Override
    protected Group addNewProjectObject(Group group) throws ProjectException {
        this.getOrganization().addOrganizationalObject((ProjectObject)group);
        return group;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new GroupExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        return this.getOrganization().findGroup(suggestedName) != null;
    }
}

