/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.CalendarRuleExistenceValidator;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class CalendarRuleDialog
extends AbstractOrganizationDialog<CalendarRule> {
    public CalendarRuleDialog(UiWindow parent, Organization organization) {
        super(parent, organization);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.CALENDAR_RULE;
    }

    @Override
    protected String getSuggestedPrefix() {
        return DesignerMsg.CALENDAR.toString();
    }

    @Override
    protected CalendarRule createNewProjectObject(String name) throws ProjectException {
        String calendarRuleId = ModelUtils.generateCalendarRuleId((Organization)this.getOrganization());
        CalendarRule calendarRule = this.getOrganization().createCalendarRule(calendarRuleId);
        calendarRule.setName(name);
        return calendarRule;
    }

    @Override
    protected CalendarRule addNewProjectObject(CalendarRule calendarRule) throws ProjectException {
        this.getOrganization().addOrganizationalObject((ProjectObject)calendarRule);
        return calendarRule;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new CalendarRuleExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        Sequence calendars = this.getOrganization().getCalendarRules();
        for (CalendarRule calendarRule : calendars) {
            if (!suggestedName.equals(calendarRule.getName())) continue;
            return true;
        }
        return false;
    }
}

