/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.organization;

import oracle.bpm.designer.dialog.AbstractDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.organization.BusinessParameterExistenceValidator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.IdentifierUpperCaseTextField;
import oracle.bpm.ui.text.TextField;

public class BusinessParameterDialog
extends AbstractDialog<BusinessParameter> {
    public BusinessParameterDialog(UiWindow parent, Project project) {
        super(parent, project);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.BUSINESS_PARAMETER;
    }

    @Override
    protected BusinessParameter createNewProjectObject(String businessParameterId) throws ProjectException {
        return this.getProject().getBusinessParametersContainer().createBusinessParameter(businessParameterId);
    }

    @Override
    protected BusinessParameter addNewProjectObject(BusinessParameter businessParameter) throws ProjectException {
        this.getProject().getBusinessParametersContainer().addChild((ProjectObject)businessParameter);
        return businessParameter;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new BusinessParameterExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new IdentifierUpperCaseTextField((UiContainer)panel, 128);
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        return this.getProject().getBusinessParametersContainer().findChild(BusinessParameter.class, suggestedName) != null;
    }

    @Override
    protected String getSuggestedPrefix() {
        return super.getSuggestedPrefix().toUpperCase();
    }
}

