/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog.customviews;

import oracle.bpm.designer.dialog.AbstractDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.customviews.PresentationExistenceValidator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.presentation.presentations.Presentation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class PresentationDialog
extends AbstractDialog<Presentation> {
    public PresentationDialog(UiWindow root, Project project) {
        super(root, project);
    }

    @Override
    protected Presentation createNewProjectObject(String presentationId) throws ProjectException {
        return this.getProject().getPresentationManager().createPresentation(presentationId);
    }

    @Override
    protected Presentation addNewProjectObject(Presentation presentation) throws ProjectException {
        this.getProject().getPresentationManager().addPresentation(presentation);
        return presentation;
    }

    @Override
    protected void addValidators(CompositeValidator compositeValidator) {
        compositeValidator.addValidator(new PresentationExistenceValidator(this.getProject()));
    }

    @Override
    protected TextField createNameTextField(Panel panel) {
        return new ValidFileTextField((UiContainer)panel, 128);
    }

    @Override
    protected Msg getTitleMsg() {
        return DesignerMsg.PRESENTATION;
    }

    @Override
    protected boolean isProjectObjectExists(String suggestedName) {
        return this.getProject().getPresentationManager().containsPresentation(suggestedName);
    }
}

