/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dialog;

import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.DesignerUtils;
import oracle.bpm.designer.dialog.organization.ProjectObjectNameValidatorAdapter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.validator.ChildExistenceValidator;
import oracle.bpm.designer.validator.CompositeValidator;
import oracle.bpm.designer.validator.EmptyNameValidator;
import oracle.bpm.designer.validator.IllegalCharactersValidator;
import oracle.bpm.designer.validator.NameLengthValidator;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDialog<PO>
extends OkCancelDialog {
    private TextField nameTextField;
    private Project project;
    private PO projectObjectAdded;
    private Msg titleMsg;

    public AbstractDialog(UiWindow parent, Project project) {
        this(parent, project, null);
    }

    public AbstractDialog(UiWindow parent, Project project, Msg titleMsg) {
        super(parent, true);
        this.project = project;
        this.titleMsg = titleMsg;
        this.init();
    }

    public void ok() {
        String name = this.getNameTextField().getText();
        name = name.trim();
        try {
            CompositeValidator<ProjectObject> validator = this.getProjectObjectValidator();
            PO objectToAdd = this.createNewProjectObject(name);
            Msg errorMessage = validator.validate((ProjectObject)objectToAdd);
            if (errorMessage != null) {
                MessageDialog.showError((Msg)errorMessage);
                this.selectText();
                return;
            }
            this.projectObjectAdded = this.addNewProjectObject(objectToAdd);
            this.setVisible(false);
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    public PO getProjectObjectAdded() {
        return this.projectObjectAdded;
    }

    public void setVisible(boolean visible) {
        TextField textField = this.getNameTextField();
        if (Str.isEmpty(textField.getText())) {
            String value = this.getSuggestedName();
            textField.setText(value);
            this.selectText();
        }
        super.setVisible(visible);
    }

    protected abstract PO addNewProjectObject(PO var1) throws ProjectException;

    protected abstract PO createNewProjectObject(String var1) throws ProjectException;

    protected abstract TextField createNameTextField(Panel var1);

    protected abstract boolean isProjectObjectExists(String var1);

    protected abstract void addValidators(CompositeValidator<ProjectObject> var1);

    protected Msg getTitleMsg() {
        return this.titleMsg != null ? this.titleMsg : DesignerMsg.EMPTY_MSG("");
    }

    protected CompositeValidator<ProjectObject> getProjectObjectValidator() {
        CompositeValidator<ProjectObject> compositeValidator = new CompositeValidator<ProjectObject>();
        CompositeValidator<String> compositeNameValidator = new CompositeValidator<String>();
        compositeNameValidator.addValidator(new EmptyNameValidator());
        compositeNameValidator.addValidator(new IllegalCharactersValidator());
        compositeNameValidator.addValidator(new NameLengthValidator(128));
        ProjectObjectNameValidatorAdapter projectObjectNameValidator = new ProjectObjectNameValidatorAdapter(compositeNameValidator);
        compositeValidator.addValidator(projectObjectNameValidator);
        compositeValidator.addValidator(new ChildExistenceValidator());
        this.addValidators(compositeValidator);
        return compositeValidator;
    }

    protected Project getProject() {
        return this.project;
    }

    protected void setProjectObjectAdded(PO projectObject) {
        this.projectObjectAdded = projectObject;
    }

    protected TextField getNameTextField() {
        return this.nameTextField;
    }

    protected void init() {
        Panel panel = new Panel(this.getContentPane());
        StandardForm form = FormsFactory.createStandardForm((UiContainer)panel);
        this.nameTextField = this.createNameTextField(panel);
        this.nameTextField.requestFocus();
        form.add(this.getLabelMsg(), (UiComponent)this.nameTextField);
        this.getContentPane().add((UiComponent)panel, (Object)"Center");
        Msg titleMsg = this.titleMsg != null ? this.titleMsg : this.getTitleMsg();
        this.setTitle(titleMsg.getString());
        this.setIconImage(Image.create((Msg)titleMsg));
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    protected Msg getLabelMsg() {
        return DesignerMsg.NAME;
    }

    protected String getSuggestedName() {
        return DesignerUtils.getSuggestedName(this.getSuggestedPrefix(), this.getProjectExistsPredicate());
    }

    protected String getSuggestedPrefix() {
        return this.getTitleMsg().getString();
    }

    private Predicate<String> getProjectExistsPredicate() {
        return new Predicate<String>(){

            @Override
            public boolean check(@Nullable String value) {
                return AbstractDialog.this.isProjectObjectExists(value);
            }
        };
    }

    private void selectText() {
        TextField textField = this.getNameTextField();
        textField.setSelectionStart(0);
        textField.setSelectionEnd(textField.getText().length());
    }
}

