/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.designer.formdesigner.Utilities;
import oracle.bpm.draw.Color;
import oracle.bpm.project.dashboard.WidgetDataModelImpl;
import oracle.bpm.project.dashboard.WidgetModelImpl;
import oracle.bpm.project.dashboard.WidgetPresentationModelImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.lib.chart.Range;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class WidgetBuilder {
    public static final FontInfo DEFAULT_VALUE_FONT = FontInfo.valueOf("Verdana", 0, 15);
    public static final ColorInfo DEFAULT_VALUE_COLOR = ColorInfo.WHITE;
    private static final int DEFAULT_WIDGET_WIDTH = 400;
    private static final int DEFAULT_WIDGET_HEIGHT = 400;
    private static final List<ColorInfo> DEFAULT_SERIES_COLORS = new ArrayList<ColorInfo>(Arrays.asList(ColorInfo.valueOf(0, 114, 234), ColorInfo.valueOf(32, 195, 30), ColorInfo.valueOf(182, 70, 184), ColorInfo.valueOf(255, 0, 42), ColorInfo.valueOf(178, 180, 179), ColorInfo.valueOf(101, 174, 255), ColorInfo.valueOf(138, 202, 136), ColorInfo.valueOf(210, 144, 212), ColorInfo.valueOf(255, 91, 91), ColorInfo.valueOf(211, 211, 211), ColorInfo.valueOf(0, 60, 126), ColorInfo.valueOf(36, 124, 34), ColorInfo.valueOf(117, 45, 119), ColorInfo.valueOf(158, 0, 26), ColorInfo.valueOf(122, 128, 131)));
    private static final BusinessVariableData.Range DEFAULT_TOTAL_RANGE = new Range(0.0, 300.0).createBVDRange();
    private static final BusinessVariableData.Range DEFAULT_NORMAL_RANGE = new Range(0.0, 100.0).createBVDRange();
    private static final BusinessVariableData.Range DEFAULT_WARNING_RANGE = new Range(100.0, 200.0).createBVDRange();
    private static final BusinessVariableData.Range DEFAULT_CRITICAL_RANGE = new Range(200.0, 300.0).createBVDRange();
    private static final boolean DEFAULT_USER_TYPE_SELECTION = false;
    private static final boolean DEFAULT_USER_REFRESH = true;
    private static final int DEFAULT_REFRESH_RATE = 30;
    public static final ColorInfo BACKGROUND_DEFAULT_COLOR = ColorInfo.WHITE;
    public static final ColorInfo FOREGROUND_DEFAULT_COLOR = ColorInfo.BLACK;
    public static final ColorInfo OUTLINE_DEFAULT_COLOR = ColorInfo.BLACK;
    public static final ColorInfo SHADOW_DEFAULT_COLOR = ColorInfo.GRAY;
    public static final ColorInfo PLOT_BACKGROUND_DEFAULT_COLOR = ColorInfo.WHITE;
    public static final ColorInfo PLOT_OUTLINE_DEFAULT_COLOR = ColorInfo.BLACK;
    public static final ColorInfo SERIES_DATA_LABEL_VALUE_COLOR = ColorInfo.BLACK;

    public static oracle.bpm.dashboard.model.WidgetModel buildDefaultWidget(Project project, String name) {
        WidgetModelImpl result = new WidgetModelImpl(project);
        result.setName(name);
        WidgetPresentationModel defaultPresentationModel = WidgetBuilder.createDefaultPresentationModel(project);
        defaultPresentationModel.asMutable().setName(name);
        defaultPresentationModel.asMutable().setTitle(name);
        result.asMutable().setPresentationModel(defaultPresentationModel);
        result.asMutable().setDataModel(WidgetBuilder.createDataModel(project));
        return result;
    }

    public static WidgetDataModel createDataModel(Project project) {
        WidgetDataModelImpl dataModel = new WidgetDataModelImpl(project);
        dataModel.asMutable().setType(WidgetType.ACTIVITY_WORKLOAD);
        return dataModel;
    }

    public static WidgetPresentationModel createDefaultPresentationModel(Project project) {
        WidgetPresentationModel.Mutable widgetPresentationModel = new WidgetPresentationModelImpl(project).asMutable();
        FullBorderPropertiesImpl border = new FullBorderPropertiesImpl();
        border.setTopborderstyle(BorderStyle.NONE);
        border.setTopColor(Utilities.getString(Color.BLACK));
        border.setTopWidth(0);
        border.setBottomborderstyle(BorderStyle.NONE);
        border.setBottomColor(Utilities.getString(Color.BLACK));
        border.setBottomWidth(0);
        border.setLeftborderstyle(BorderStyle.NONE);
        border.setLeftColor(Utilities.getString(Color.BLACK));
        border.setLeftWidth(0);
        border.setRightborderstyle(BorderStyle.NONE);
        border.setRightColor(Utilities.getString(Color.BLACK));
        border.setRightWidth(0);
        widgetPresentationModel.setBorder((FullBorderProperties)border);
        widgetPresentationModel.setType(WidgetGraphicType.GAUGE);
        widgetPresentationModel.setSubType(GraphicType.GAUGE_SPEEDOMETER);
        widgetPresentationModel.setTotalRange(DEFAULT_TOTAL_RANGE);
        widgetPresentationModel.setNormalRange(DEFAULT_NORMAL_RANGE);
        widgetPresentationModel.setWarningRange(DEFAULT_WARNING_RANGE);
        widgetPresentationModel.setCriticalRange(DEFAULT_CRITICAL_RANGE);
        widgetPresentationModel.setNormalRangeColor(ColorInfo.GREEN);
        widgetPresentationModel.setWarningRangeColor(ColorInfo.YELLOW);
        widgetPresentationModel.setCriticalRangeColor(ColorInfo.RED);
        widgetPresentationModel.setValueColor(DEFAULT_VALUE_COLOR);
        widgetPresentationModel.setValueFont(DEFAULT_VALUE_FONT);
        widgetPresentationModel.setDataLabelFormat("{0} = {1}");
        widgetPresentationModel.setSeriesDataLabelFont(FontInfo.valueOf("Verdana", 1, 15));
        widgetPresentationModel.setSeriesDataLabelColor(ColorInfo.BLACK);
        widgetPresentationModel.setSeriesColor(DEFAULT_SERIES_COLORS);
        widgetPresentationModel.setBackgroundColor(BACKGROUND_DEFAULT_COLOR);
        widgetPresentationModel.setForegroundColor(FOREGROUND_DEFAULT_COLOR);
        widgetPresentationModel.setPlotBackgroundColor(PLOT_BACKGROUND_DEFAULT_COLOR);
        widgetPresentationModel.setOutlineColor(OUTLINE_DEFAULT_COLOR);
        widgetPresentationModel.setPlotOutlineColor(PLOT_OUTLINE_DEFAULT_COLOR);
        widgetPresentationModel.setSeriesDataLabelColor(SERIES_DATA_LABEL_VALUE_COLOR);
        widgetPresentationModel.setShadowColor(SHADOW_DEFAULT_COLOR);
        widgetPresentationModel.setWidth(400);
        widgetPresentationModel.setHeight(400);
        widgetPresentationModel.setTitleFont(FontInfo.valueOf("Verdana", 0, 15));
        widgetPresentationModel.setTitleBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setTitleForegroundColor(ColorInfo.BLACK);
        widgetPresentationModel.setRefreshRate(30);
        widgetPresentationModel.setTypeSelectionAllowed(false);
        widgetPresentationModel.setUsrSelectionAllowed(true);
        return widgetPresentationModel;
    }

    public static String getDefaultName(Project project) {
        String result = "";
        int counter = 1;
        HashSet<String> widgetIds = new HashSet<String>();
        List widgetList = project.getWidgetsList();
        for (WidgetModel widgetModel : widgetList) {
            widgetIds.add(widgetModel.getId());
        }
        try {
            while (widgetIds.contains(result = "Widget" + counter++)) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }
}

