/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.templates;

import java.util.ArrayList;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.designer.dashboardwizards.templates.BeaColorPalette;
import oracle.bpm.designer.dashboardwizards.templates.PredefinedDashboardFactory;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.project.dashboard.DimensionFactoryImpl;
import oracle.bpm.project.dashboard.MeasurementFactoryImpl;
import oracle.bpm.project.dashboard.WidgetDataModelImpl;
import oracle.bpm.project.dashboard.WidgetModelImpl;
import oracle.bpm.project.dashboard.WidgetPresentationModelImpl;
import oracle.bpm.project.dashboard.drilldown.InstancesViewDrillDownAdapter;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.project.model.Project;
import oracle.bpm.xobject.GraphicType;

public class WorkloadDashboardFactory
extends PredefinedDashboardFactory {
    public WorkloadDashboardFactory(Project project) {
        super(project);
    }

    public DashboardModel getMainDashboard() {
        DashboardModelImpl dashboard = new DashboardModelImpl(this.project);
        dashboard.setName("InstanceWorkloadDashboard");
        dashboard.setColumns(1);
        dashboard.setRows(1);
        this.addDashboardCommonProperties((DashboardModel.Mutable)dashboard);
        dashboard.setTitleBackground(BeaColorPalette.BEA_BLUE_1);
        dashboard.putLocalizedTitles(LibMsg.OOTBD_WORKLOAD_DASHBOARD_TITLE.getAllAvailableTranslationsForProjectLanguages());
        dashboard.putLocalizedDescriptions(LibMsg.OOTBD_WORKLOAD_DASHBOARD_DESC.getAllAvailableTranslationsForProjectLanguages());
        dashboard.addWidget(this.getWorkloadByOuWidget());
        return dashboard;
    }

    WidgetModel getWorkloadByOuWidget() {
        String name = "OrganizationalUnitInstanceWorkload";
        WidgetModelImpl workloadByOu = new WidgetModelImpl(this.project);
        workloadByOu.setName(name);
        WidgetDataModelImpl dataModel = new WidgetDataModelImpl(this.project);
        dataModel.setType(WidgetType.ALL_OUS_WORKLOAD);
        dataModel.setWidgetValueType(WidgetValueType.VALUE);
        dataModel.setHasDrillDown(true);
        dataModel.setDrillDown((DrillDown)new WidgetDrillDownAdapter(this.getWorkloadByProcessWidget(), true));
        Measurement numberOfInstancesMeasurement = new MeasurementFactoryImpl(this.project).getNumberOfInstancesMeasurement();
        numberOfInstancesMeasurement.setOperationType(OperationType.SUM);
        dataModel.setMeasurement(numberOfInstancesMeasurement);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createOuDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModelImpl presentationModel = new WidgetPresentationModelImpl(this.project);
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_WORKLOAD_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addXYProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addGaugeProperties((WidgetPresentationModel.Mutable)presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }

    private WidgetModel getWorkloadByProcessWidget() {
        String name = "ProcessInstanceWorkload";
        WidgetModelImpl workloadByOu = new WidgetModelImpl(this.project);
        workloadByOu.setName(name);
        WidgetDataModelImpl dataModel = new WidgetDataModelImpl(this.project);
        dataModel.setType(WidgetType.OU_WORKLOAD);
        dataModel.setWidgetValueType(WidgetValueType.VALUE);
        dataModel.setHasDrillDown(true);
        dataModel.setDrillDown((DrillDown)new WidgetDrillDownAdapter(this.getWorkloadByActivityWidget(), true));
        dataModel.setParametricOu(true);
        Measurement numberOfInstancesMeasurement = new MeasurementFactoryImpl(this.project).getNumberOfInstancesMeasurement();
        numberOfInstancesMeasurement.setOperationType(OperationType.SUM);
        dataModel.setMeasurement(numberOfInstancesMeasurement);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createProcessDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModelImpl presentationModel = new WidgetPresentationModelImpl(this.project);
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_WORKLOAD_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addXYProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addGaugeProperties((WidgetPresentationModel.Mutable)presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }

    private WidgetModel getWorkloadByActivityWidget() {
        String name = "ActivityInstanceWorkload";
        WidgetModelImpl workloadByOu = new WidgetModelImpl(this.project);
        workloadByOu.setName(name);
        WidgetDataModelImpl dataModel = new WidgetDataModelImpl(this.project);
        dataModel.setType(WidgetType.ALL_ACTIVITIES_WORKLOAD);
        dataModel.setWidgetValueType(WidgetValueType.VALUE);
        dataModel.setHasDrillDown(true);
        dataModel.setDrillDown((DrillDown)new InstancesViewDrillDownAdapter());
        dataModel.setParametricOu(true);
        dataModel.setParametricProcess(true);
        Measurement numberOfInstancesMeasurement = new MeasurementFactoryImpl(this.project).getNumberOfInstancesMeasurement();
        numberOfInstancesMeasurement.setOperationType(OperationType.SUM);
        dataModel.setMeasurement(numberOfInstancesMeasurement);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createActivityDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModelImpl presentationModel = new WidgetPresentationModelImpl(this.project);
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_WORKLOAD_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addXYProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addGaugeProperties((WidgetPresentationModel.Mutable)presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }
}

