/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.templates;

import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.dashboardwizards.templates.BeaColorPalette;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.xobject.lib.chart.Range;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class PredefinedDashboardFactory {
    protected Project project;
    private static final ColorInfo VALUE_COLOR;
    private static final ColorInfo WIDGET_BACKGROUND_COLOR;
    private static final ColorInfo TITLE_FOREGROUND;
    private static final ColorInfo BACKGROUND;
    private static final FontInfo TITLE_FONT;
    private static final boolean SHOW_REFRESH_BUTTON = true;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 400;
    private static final int REFRESH__RATE = 30;
    private static final ColorInfo TITLE_FOREGROUND_COLOR;
    private static final ColorInfo SHADOW_COLOR;
    private static final FontInfo SERIES_DATA_LABEL_FONT;
    private static final ColorInfo CRITICAL_RANGE_COLOR;
    private static final ColorInfo WARNING_RANGE_COLOR;
    private static final ColorInfo NORMAL_RANGE_COLOR;
    private static final BusinessVariableData.Range TOTAL_RANGE;
    private static final BusinessVariableData.Range NORMAL_RANGE;
    private static final BusinessVariableData.Range WARNING_RANGE;
    private static final BusinessVariableData.Range CRITICAL_RANGE;
    private static final ColorInfo FOREGROUND_COLOR;
    private static final FontInfo VALUE_FONT;
    private static final FontInfo WIDGET_TITLE_FONT;

    public PredefinedDashboardFactory(Project project) {
        this.project = project;
    }

    protected void addDashboardCommonProperties(DashboardModel.Mutable dashboard) {
        dashboard.setBackground(BACKGROUND);
        dashboard.setTitleForeground(TITLE_FOREGROUND);
        dashboard.setTitleFont(TITLE_FONT);
    }

    protected void addCommonWidgetProperties(WidgetPresentationModel.Mutable presentationModel) {
        presentationModel.setUsrSelectionAllowed(true);
        presentationModel.setHeight(400);
        presentationModel.setWidth(400);
        presentationModel.setOrientation(1);
        presentationModel.setRefreshRate(30);
        presentationModel.setBackgroundColor(WIDGET_BACKGROUND_COLOR);
        presentationModel.setTitleBackgroundColor(WIDGET_BACKGROUND_COLOR);
        presentationModel.setTitleForegroundColor(TITLE_FOREGROUND_COLOR);
        presentationModel.setOutlineColor(VALUE_COLOR);
        presentationModel.setPlotOutlineColor(FOREGROUND_COLOR);
        presentationModel.setShadowColor(SHADOW_COLOR);
        presentationModel.setPlotBackgroundColor(VALUE_COLOR);
        presentationModel.setTitleFont(WIDGET_TITLE_FONT);
        presentationModel.setSeriesColor(BeaColorPalette.getColorPalette());
        FullBorderPropertiesImpl fullBorderProperties = new FullBorderPropertiesImpl();
        fullBorderProperties.setTopborderstyle(BorderStyle.NONE);
        fullBorderProperties.setRightborderstyle(BorderStyle.NONE);
        fullBorderProperties.setBottomborderstyle(BorderStyle.NONE);
        fullBorderProperties.setLeftborderstyle(BorderStyle.NONE);
        presentationModel.setBorder((FullBorderProperties)fullBorderProperties);
    }

    protected void addXYProperties(WidgetPresentationModel.Mutable presentationModel) {
        presentationModel.setSeriesDataLabelFont(SERIES_DATA_LABEL_FONT);
        ColorInfo SERIES_DATA_LABEL_COLOR = FOREGROUND_COLOR;
        presentationModel.setSeriesDataLabelColor(SERIES_DATA_LABEL_COLOR);
    }

    protected void addGaugeProperties(WidgetPresentationModel.Mutable presentationModel) {
        presentationModel.setCriticalRangeColor(CRITICAL_RANGE_COLOR);
        presentationModel.setWarningRangeColor(WARNING_RANGE_COLOR);
        presentationModel.setNormalRangeColor(NORMAL_RANGE_COLOR);
        presentationModel.setTotalRange(TOTAL_RANGE);
        presentationModel.setNormalRange(NORMAL_RANGE);
        presentationModel.setWarningRange(WARNING_RANGE);
        presentationModel.setCriticalRange(CRITICAL_RANGE);
        presentationModel.setForegroundColor(FOREGROUND_COLOR);
        presentationModel.setValueFont(VALUE_FONT);
        presentationModel.setValueColor(VALUE_COLOR);
    }

    static {
        BACKGROUND = TITLE_FOREGROUND = (WIDGET_BACKGROUND_COLOR = (VALUE_COLOR = ColorInfo.WHITE));
        TITLE_FONT = FontInfo.valueOf("Verdana", 1, 17);
        TITLE_FOREGROUND_COLOR = ColorInfo.valueOf(51, 51, 51);
        SHADOW_COLOR = ColorInfo.valueOf(128, 128, 128);
        SERIES_DATA_LABEL_FONT = FontInfo.valueOf("Verdana", 0, 12);
        CRITICAL_RANGE_COLOR = ColorInfo.RED;
        WARNING_RANGE_COLOR = ColorInfo.YELLOW;
        NORMAL_RANGE_COLOR = ColorInfo.GREEN;
        TOTAL_RANGE = new Range(0.0, 300.0).createBVDRange();
        NORMAL_RANGE = new Range(0.0, 100.0).createBVDRange();
        WARNING_RANGE = new Range(100.0, 200.0).createBVDRange();
        CRITICAL_RANGE = new Range(200.0, 300.0).createBVDRange();
        FOREGROUND_COLOR = ColorInfo.BLACK;
        VALUE_FONT = FontInfo.valueOf("Verdana", 0, 15);
        WIDGET_TITLE_FONT = FontInfo.valueOf("Verdana", 1, 13);
    }
}

