/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.templates;

import java.util.ArrayList;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.designer.dashboardwizards.templates.BeaColorPalette;
import oracle.bpm.designer.dashboardwizards.templates.PredefinedDashboardFactory;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.project.dashboard.DimensionFactoryImpl;
import oracle.bpm.project.dashboard.MeasurementFactoryImpl;
import oracle.bpm.project.dashboard.WidgetDataModelImpl;
import oracle.bpm.project.dashboard.WidgetModelImpl;
import oracle.bpm.project.dashboard.WidgetPresentationModelImpl;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.project.model.Project;
import oracle.bpm.xobject.GraphicType;

public class PerformanceDashboardFactory
extends PredefinedDashboardFactory {
    public PerformanceDashboardFactory(Project project) {
        super(project);
    }

    public DashboardModel getMainDashboard() {
        DashboardModelImpl dashboard = new DashboardModelImpl(this.project);
        dashboard.setName("PerformanceDashboard");
        dashboard.setColumns(1);
        dashboard.setRows(1);
        this.addDashboardCommonProperties((DashboardModel.Mutable)dashboard);
        dashboard.setTitleBackground(BeaColorPalette.BEA_GRAY_1);
        dashboard.putLocalizedTitles(LibMsg.OOTBD_PERFORMANCE_DASHBOARD_TITLE.getAllAvailableTranslationsForProjectLanguages());
        dashboard.putLocalizedDescriptions(LibMsg.OOTBD_PERFORMANCE_DASHBOARD_DESC.getAllAvailableTranslationsForProjectLanguages());
        dashboard.addWidget(this.getPerformanceByOuWidget());
        return dashboard;
    }

    WidgetModel getPerformanceByOuWidget() {
        String name = "OrganizationalUnitPerformance";
        WidgetModel.Mutable workloadByOu = new WidgetModelImpl(this.project).asMutable();
        workloadByOu.setName(name);
        WidgetDataModel.Mutable dataModel = new WidgetDataModelImpl(this.project).asMutable();
        dataModel.setType(WidgetType.ALL_OUS_PROCESS_PERFORMANCE);
        dataModel.setWidgetValueType(WidgetValueType.AUTOMATIC_TIME_HANDLING);
        dataModel.setHasDrillDown(true);
        dataModel.setDrillDown((DrillDown)new WidgetDrillDownAdapter(this.getPerformanceByProcessWidget(), true));
        Measurement processTime = new MeasurementFactoryImpl(this.project).getProcessTimeMeasurement();
        processTime.setOperationType(OperationType.AVG);
        dataModel.setMeasurement(processTime);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createOuDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModel.Mutable presentationModel = new WidgetPresentationModelImpl(this.project).asMutable();
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_OU_PROCESS_PERFORMANCE_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties(presentationModel);
        this.addXYProperties(presentationModel);
        this.addGaugeProperties(presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }

    private WidgetModel getPerformanceByProcessWidget() {
        String name = "ProcessPerformance";
        WidgetModel.Mutable workloadByOu = new WidgetModelImpl(this.project).asMutable();
        workloadByOu.setName(name);
        WidgetDataModel.Mutable dataModel = new WidgetDataModelImpl(this.project).asMutable();
        dataModel.setType(WidgetType.OU_PROCESS_PERFORMANCE);
        dataModel.setWidgetValueType(WidgetValueType.AUTOMATIC_TIME_HANDLING);
        dataModel.setHasDrillDown(true);
        dataModel.setDrillDown((DrillDown)new WidgetDrillDownAdapter(this.getPerformanceByActivityWidget(), true));
        dataModel.setParametricOu(true);
        Measurement processTime = new MeasurementFactoryImpl(this.project).getProcessTimeMeasurement();
        processTime.setOperationType(OperationType.AVG);
        dataModel.setMeasurement(processTime);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createProcessDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModel.Mutable presentationModel = new WidgetPresentationModelImpl(this.project).asMutable();
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_OU_PROCESS_PERFORMANCE_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties(presentationModel);
        this.addXYProperties(presentationModel);
        this.addGaugeProperties(presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }

    private WidgetModel getPerformanceByActivityWidget() {
        String name = "ActivityPerformance";
        WidgetModelImpl workloadByOu = new WidgetModelImpl(this.project);
        workloadByOu.setName(name);
        WidgetDataModel.Mutable dataModel = new WidgetDataModelImpl(this.project).asMutable();
        dataModel.setType(WidgetType.ALL_ACTIVITIES_PERFORMANCE);
        dataModel.setWidgetValueType(WidgetValueType.AUTOMATIC_TIME_HANDLING);
        dataModel.setHasDrillDown(false);
        dataModel.setParametricOu(true);
        dataModel.setParametricProcess(true);
        Measurement measurement = new MeasurementFactoryImpl(this.project).getTaskTimeMeasurement();
        measurement.setOperationType(OperationType.AVG);
        dataModel.setMeasurement(measurement);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add(new DimensionFactoryImpl(this.project).createActivityDimension(false));
        dataModel.setDimensions(dimensions);
        workloadByOu.setDataModel((WidgetDataModel)dataModel);
        WidgetPresentationModelImpl presentationModel = new WidgetPresentationModelImpl(this.project);
        presentationModel.setName(name);
        presentationModel.setLocalizedTitles(LibMsg.OOTBD_ACIVITY_PERFORMACE_WIDGET_TITLE.getAllAvailableTranslationsForProjectLanguages());
        presentationModel.setType(WidgetGraphicType.CHART);
        presentationModel.setSubType(GraphicType.BAR_CHART_3D);
        this.addCommonWidgetProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addXYProperties((WidgetPresentationModel.Mutable)presentationModel);
        this.addGaugeProperties((WidgetPresentationModel.Mutable)presentationModel);
        workloadByOu.setPresentationModel((WidgetPresentationModel)presentationModel);
        return workloadByOu;
    }
}

