/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel;

import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.dashboardwizards.components.ActivitiesCombo;
import oracle.bpm.designer.dashboardwizards.components.DimensionChooser;
import oracle.bpm.designer.dashboardwizards.components.MeasurementsCombo;
import oracle.bpm.designer.dashboardwizards.components.RadioPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourceListenerManager;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourceLoader;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;

public class WidgetDataSourcePanelComponentFactory {
    public boolean advancedModePanelBuilt;
    public CardLayout processCardLayout;
    public ProcessIdentifier processIdentifierPanel;
    ActivitiesCombo activitiesCombo;
    RadioButton activityPerformanceRadio;
    RadioButton activityRadioButton;
    boolean advancedMode;
    RadioButton allActivitiesRadioButton;
    DimensionChooser dimensionChooser;
    boolean doFireEvents;
    RadioButton invisibleProcessRadioButton;
    WidgetDataSourceLoader loader;
    MeasurementsCombo measurementsCombo;
    Label nameTextField;
    RadioPanel operationTypePanel;
    ComboBox<Process> processCombo;
    RadioButton processesRadio;
    RadioButton processPerformanceRadio;
    TextField titleTextField;
    RadioPanel valueTypePanel;
    WidgetDataModel widgetDataModel;
    WidgetPresentationModel widgetPresentationModel;
    RadioButton workloadRadio;
    private Panel activitiesPanel;
    private Panel dataTypePanel;
    private Panel dimensionsPanel;
    private WidgetDataSourceListenerManager listenerManager;
    private Panel measurementPanel;
    private Panel namePanel;
    private Panel ouProcessChooser;
    private Project project;
    private WidgetModel widgetModel;

    public WidgetDataSourcePanelComponentFactory(WidgetModel widgetModel) {
        this.widgetModel = widgetModel;
        this.widgetDataModel = widgetModel.getDataModel();
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.project = widgetModel.getProject();
        this.listenerManager = new WidgetDataSourceListenerManager(this, this.project);
        this.loader = new WidgetDataSourceLoader(this, this.project);
    }

    public void init(WidgetDataSourcePanel dataSourcePanel) {
        this.buildComponents(dataSourcePanel);
        this.doFireEvents = true;
    }

    public RadioPanel getValueTypePanel() {
        return this.valueTypePanel;
    }

    public ActivitiesCombo getActivitiesCombo() {
        return this.activitiesCombo;
    }

    public RadioButton getActivityPerformanceRadio() {
        return this.activityPerformanceRadio;
    }

    public RadioButton getActivityRadioButton() {
        return this.activityRadioButton;
    }

    public RadioButton getAllActivitiesRadioButton() {
        return this.allActivitiesRadioButton;
    }

    public boolean isAllActivitiesRadioSelected() {
        return this.allActivitiesRadioButton != null && this.allActivitiesRadioButton.isSelected();
    }

    public DimensionChooser getDimensionChooser() {
        return this.dimensionChooser;
    }

    public MeasurementsCombo getMeasurementsCombo() {
        return this.measurementsCombo;
    }

    public Label getNameTextField() {
        return this.nameTextField;
    }

    public RadioPanel getOperationTypePanel() {
        return this.operationTypePanel;
    }

    public ComboBox getProcessCombo() {
        return this.processCombo;
    }

    public RadioButton getProcessPerformanceRadio() {
        return this.processPerformanceRadio;
    }

    public TextField getTitleTextField() {
        return this.titleTextField;
    }

    public RadioButton getWorkloadRadio() {
        return this.workloadRadio;
    }

    public void reloadTitle() {
        this.doFireEvents = false;
        this.titleTextField.setText(this.widgetPresentationModel.getTitle());
        this.doFireEvents = true;
    }

    public Panel getProcessesIdentifier() {
        return this.processIdentifierPanel;
    }

    public boolean isAdvancedMode() {
        return this.advancedMode;
    }

    public void setModel(WidgetModel widgetModel) {
        this.widgetModel = widgetModel;
        this.widgetDataModel = widgetModel.getDataModel();
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.listenerManager.setDoFireEvents(false);
        this.dimensionChooser.setModel(this.widgetDataModel);
        this.loadValues();
        this.listenerManager.setDoFireEvents(true);
    }

    public void updateMeasurementsCombo(Measurement measurement) {
        this.measurementsCombo.updateMeasurement(measurement);
        this.measurementsCombo.setSelectedItem(measurement);
    }

    public void guessType() {
        this.widgetModel.guessTypeBasedOnDimensions();
    }

    public Button getLocalizationButtonForTitle(UiContainer parent) {
        return DesignerResources.buildLocalizationButton(this.widgetModel.getProject(), parent, this.widgetPresentationModel.getLocalizedTitles(), (TextComponent)this.titleTextField, DesignerMsg.LOCALIZE_LABEL.getString(), true);
    }

    public void setActivitiesPanel(Panel activitiesPanel) {
        this.activitiesPanel = activitiesPanel;
    }

    public void setDataTypePanel(Panel dataTypePanel) {
        this.dataTypePanel = dataTypePanel;
    }

    public void setDimensionsPanel(Panel dimensionsPanel) {
        this.dimensionsPanel = dimensionsPanel;
    }

    public void setMeasurementPanel(Panel measurementPanel) {
        this.measurementPanel = measurementPanel;
    }

    public void setNamePanel(Panel namePanel) {
        this.namePanel = namePanel;
    }

    public void setOuProcessChooser(Panel ouProcessChooser) {
        this.ouProcessChooser = ouProcessChooser;
    }

    void loadValues() {
        this.loader.loadNameAndTitle();
        this.loader.loadType();
        this.loader.loadProcessOrOu();
        this.loader.loadActivity();
        this.loader.loadDimensions();
        this.loader.loadMeasure();
        this.loader.loadValueType();
        this.loader.loadOperation();
    }

    void changeWidgetType(boolean reloadDimensions) {
        Process process = (Process)this.processCombo.getSelectedItem();
        if (this.widgetDataModel.getType().isOuType()) {
            this.dimensionChooser.reload();
            if (this.measurementsCombo != null) {
                this.widgetDataModel.asMutable().setMeasurement(null);
                this.measurementsCombo.reload(this.widgetDataModel.getType());
            }
        }
        if (process != null) {
            if (this.widgetDataModel.getType() == WidgetType.ACTIVITY_WORKLOAD || this.widgetDataModel.getType() == WidgetType.ACTIVITY_PERFORMANCE) {
                this.loader.reloadActivitiesCombo();
            }
            if (reloadDimensions && this.loader.shouldReloadTableBasedOnProcess()) {
                this.dimensionChooser.reload();
            }
            if (this.measurementsCombo != null) {
                this.widgetDataModel.asMutable().setMeasurement(null);
                this.measurementsCombo.reload(this.widgetDataModel.getType(), process);
            }
        }
    }

    void storeActivityIdToDataModel(ProjectObject projectElement) {
        if (projectElement != null) {
            String measurementMarkId = projectElement.getId();
            if (projectElement instanceof MeasurementImpl) {
                measurementMarkId = MeasurementImpl.getBAMMeasurementMarkId((String)projectElement.getId());
            }
            this.widgetDataModel.asMutable().setActivityId(measurementMarkId);
        } else {
            this.widgetDataModel.asMutable().setActivityId(null);
        }
    }

    void enableValues(boolean enable) {
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.DAYS, enable);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.HOURS, enable);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.MINUTES, enable);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.SECONDS, enable);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.AUTOMATIC_TIME_HANDLING, enable);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.PERCENTAGE, false);
    }

    private Process getProcessContent() {
        return (Process)this.processCombo.getSelectedItem();
    }

    private void buildActivitiesCombo(UiContainer parent) {
        Process process = (Process)this.processCombo.getSelectedItem();
        this.activitiesCombo = process != null ? new ActivitiesCombo(parent, process, WidgetType.ACTIVITY_WORKLOAD.equals((Object)this.widgetDataModel.getType())) : new ActivitiesCombo(parent);
        this.listenerManager.addListenerToActivitiesCombo();
    }

    private void buildActivitiesRadioButtons(UiContainer parent) {
        ButtonGroup group = new ButtonGroup();
        this.activityRadioButton = new RadioButton(parent, DesignerMsg.ACTIVITY);
        this.listenerManager.addListenerToActivitiesRadioButton();
        group.add((AbstractButton)this.activityRadioButton);
        this.allActivitiesRadioButton = new RadioButton(parent, DesignerMsg.ALL_ACTIVITIES);
        this.listenerManager.addListenerToAllActivitiesRadioButton();
        group.add((AbstractButton)this.allActivitiesRadioButton);
        this.invisibleProcessRadioButton = new RadioButton(parent);
        group.add((AbstractButton)this.invisibleProcessRadioButton);
    }

    private void buildActivityPerformanceRadio(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
        this.activityPerformanceRadio = new RadioButton(parent, DesignerMsg.PERFORMANCE);
        this.listenerManager.addListenerToActivityPerformanceRadio(dataSourcePanel);
    }

    private void buildTypeRadios(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
        this.buildWorkloadRadio(parent, dataSourcePanel);
        this.buildActivityPerformanceRadio(parent, dataSourcePanel);
        this.buildProcessPerformanceRadio(parent, dataSourcePanel);
        this.loader.loadType();
    }

    private void buildComponents(WidgetDataSourcePanel dataSourcePanel) {
        this.listenerManager.setDoFireEvents(false);
        this.buildNameTextField((UiContainer)this.namePanel);
        this.buildTitleTextField((UiContainer)this.namePanel, dataSourcePanel);
        this.buildOuProcessChooser((UiContainer)this.ouProcessChooser);
        this.buildActivitiesCombo((UiContainer)this.activitiesPanel);
        this.buildDimensionChooser(dataSourcePanel);
        this.buildActivitiesRadioButtons((UiContainer)this.activitiesPanel);
        this.buildTypeRadios((UiContainer)this.dataTypePanel, dataSourcePanel);
        this.buildValuePanel((UiContainer)this.measurementPanel);
        this.buildMeasurementCombo((UiContainer)this.measurementPanel);
        this.buildOperationPanel((UiContainer)this.measurementPanel);
        this.loadValues();
        this.listenerManager.setDoFireEvents(true);
    }

    private void buildDimensionChooser(WidgetDataSourcePanel dataSourcePanel) {
        this.dimensionChooser = new DimensionChooser((UiContainer)this.dimensionsPanel, this.widgetDataModel);
        this.listenerManager.addListenerToDimensionsTableModel(dataSourcePanel);
    }

    private void buildOuProcessChooser(UiContainer parent) {
        this.buildProcessesIdentifier(parent);
        this.buildProcessCombo(parent);
        this.loader.loadProcessOrOu();
    }

    private void buildProcessesIdentifier(UiContainer parent) {
        this.processIdentifierPanel = new ProcessIdentifier(parent);
    }

    private void buildDimensionsTable(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
    }

    private void buildMeasurementCombo(UiContainer parent) {
        ProjectObject selectedElement = (ProjectObject)this.activitiesCombo.getSelectedItem();
        this.measurementsCombo = selectedElement != null ? new MeasurementsCombo(this.widgetModel.getProject(), parent, this.widgetDataModel.getType(), selectedElement, this.getProcessContent()) : new MeasurementsCombo(this.widgetModel.getProject(), parent);
        this.listenerManager.addListenerToMeasurementsCombo(this.measurementsCombo);
    }

    private void buildNameTextField(UiContainer parent) {
        this.nameTextField = Label.create((UiContainer)parent, (Msg)Msg.QUOTE(this.widgetPresentationModel.getName()));
    }

    private RadioPanel buildValuePanel(UiContainer parent) {
        WidgetValueType widgetValueType = WidgetValueType.VALUE;
        this.valueTypePanel = new RadioPanel(parent, (Enum)widgetValueType, 1, new int[]{3, 3, 1});
        this.valueTypePanel.setEnabled(true);
        this.valueTypePanel.enableEnums(Arrays.asList(WidgetValueType.values()), false);
        this.valueTypePanel.enableEnum((Enum)WidgetValueType.VALUE, true);
        this.valueTypePanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetDataSourcePanelComponentFactory.this.widgetDataModel.asMutable().setWidgetValueType((WidgetValueType)WidgetDataSourcePanelComponentFactory.this.valueTypePanel.getSelectedEnum());
            }
        });
        return this.valueTypePanel;
    }

    private RadioPanel buildOperationPanel(UiContainer parent) {
        OperationType operationType = this.widgetDataModel.getMeasurement() != null ? this.widgetDataModel.getMeasurement().getOperationType() : OperationType.SUM;
        this.operationTypePanel = new RadioPanel(parent, (Enum)operationType, 0);
        this.operationTypePanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Measurement measurement = WidgetDataSourcePanelComponentFactory.this.widgetDataModel.getMeasurement();
                if (measurement != null) {
                    measurement.setOperationType((OperationType)WidgetDataSourcePanelComponentFactory.this.operationTypePanel.getSelectedEnum());
                }
            }
        });
        return this.operationTypePanel;
    }

    private void buildProcessCombo(UiContainer parent) {
        this.processCombo = UiFactory.createComboBox((UiContainer)parent, new ArrayList(this.project.getProcesses()));
        if (!this.advancedMode) {
            this.loader.loadProcessOrOu();
        }
        this.listenerManager.addListenerToProcessCombo();
        this.processCombo.setLabelProvider((LabelProvider)new LabelProvider.Default<Process>(){

            public String getText(Process element) {
                return element != null ? element.getLabel(WidgetDataSourcePanelComponentFactory.this.project.getDefaultLanguage()) : "";
            }
        });
    }

    private void buildProcessPerformanceRadio(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
        this.processPerformanceRadio = new RadioButton(parent, DesignerMsg.PROCESS_PERFORMANCE);
        this.listenerManager.addListenerToProcessPerformanceRadio(dataSourcePanel);
    }

    private void buildTitleTextField(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
        this.titleTextField = new TextField(parent, 25);
        this.titleTextField.setText(this.widgetPresentationModel.getTitle());
        this.listenerManager.addListenerToTitleTextField(dataSourcePanel);
    }

    private void buildWorkloadRadio(UiContainer parent, WidgetDataSourcePanel dataSourcePanel) {
        this.workloadRadio = new RadioButton(parent, DesignerMsg.ACTIVITY_WORKLOAD);
        this.listenerManager.addListenerToWorkloadRadioButton(dataSourcePanel);
    }

    public class ProcessIdentifier
    extends Panel {
        private CardLayout processCardLayout;
        static final String RADIO_ID = "radio";
        static final String LABEL_ID = "label";

        public ProcessIdentifier(UiContainer parent) {
            super(parent);
            this.processCardLayout = new CardLayout();
            this.setLayout((Layout)this.processCardLayout);
            WidgetDataSourcePanelComponentFactory.this.processesRadio = new RadioButton((UiContainer)this, PapiMsg.PROCESS);
            this.add((UiComponent)WidgetDataSourcePanelComponentFactory.this.processesRadio, RADIO_ID);
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)PapiMsg.PROCESS), LABEL_ID);
            WidgetDataSourcePanelComponentFactory.this.listenerManager.addListenerToProcessesRadio();
            this.processCardLayout.show((UiContainer)this, LABEL_ID);
        }
    }
}

